/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.common;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.fs.compat.common.HdfsCompatSuite;

public class HdfsCompatReport {
    private final String uri;
    private final HdfsCompatSuite suite;
    private final ConcurrentLinkedQueue<String> passed = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<String> failed = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<String> skipped = new ConcurrentLinkedQueue();

    public HdfsCompatReport() {
        this(null, null);
    }

    public HdfsCompatReport(String uri, HdfsCompatSuite suite) {
        this.uri = uri;
        this.suite = suite;
    }

    public void addPassedCase(Collection<String> cases) {
        this.passed.addAll(cases);
    }

    public void addFailedCase(Collection<String> cases) {
        this.failed.addAll(cases);
    }

    public void addSkippedCase(Collection<String> cases) {
        this.skipped.addAll(cases);
    }

    public void merge(HdfsCompatReport other) {
        this.passed.addAll(other.passed);
        this.failed.addAll(other.failed);
        this.skipped.addAll(other.skipped);
    }

    public Collection<String> getPassedCase() {
        return this.passed;
    }

    public Collection<String> getFailedCase() {
        return this.failed;
    }

    public Collection<String> getSkippedCase() {
        return this.skipped;
    }

    public String getUri() {
        return this.uri;
    }

    public HdfsCompatSuite getSuite() {
        return this.suite;
    }
}

