/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.common;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsCompatEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsCompatEnvironment.class);
    private static final String DATE_FORMAT = "yyyy_MM_dd_HH_mm_ss";
    private static final Random RANDOM = new Random();
    private final Path uri;
    private final Configuration conf;
    private FileSystem fs;
    private LocalFileSystem localFs;
    private Path rootDir;
    private Path baseDir;
    private String defaultLocalDir;
    private String[] defaultStoragePolicyNames;

    public HdfsCompatEnvironment(Path uri, Configuration conf) {
        this.conf = conf;
        this.uri = uri;
    }

    public void init() throws IOException {
        Date now = new Date();
        String uuid = UUID.randomUUID().toString();
        String uniqueDir = "hadoop-compatibility-benchmark/" + new SimpleDateFormat(DATE_FORMAT).format(now) + "/" + uuid;
        this.fs = this.uri.getFileSystem(this.conf);
        this.localFs = FileSystem.getLocal((Configuration)this.conf);
        this.rootDir = this.fs.makeQualified(new Path("/"));
        this.baseDir = this.fs.makeQualified(new Path(this.uri, uniqueDir));
        String tmpdir = this.getEnvTmpDir();
        if (tmpdir == null || tmpdir.isEmpty()) {
            LOG.warn("Cannot get valid io.tmpdir, will use /tmp");
            tmpdir = "/tmp";
        }
        this.defaultLocalDir = new File(tmpdir, uniqueDir).getAbsolutePath();
        this.defaultStoragePolicyNames = this.getDefaultStoragePolicyNames();
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public LocalFileSystem getLocalFileSystem() {
        return this.localFs;
    }

    public Path getRoot() {
        return this.rootDir;
    }

    public Path getBase() {
        return this.baseDir;
    }

    public String getLocalTmpDir() {
        String scheme = this.uri.toUri().getScheme();
        String key = "fs." + scheme + ".compatibility.local.tmpdir";
        String localDir = this.conf.get(key, null);
        return localDir != null ? localDir : this.defaultLocalDir;
    }

    public String getPrivilegedUser() {
        String scheme = this.uri.toUri().getScheme();
        String key = "fs." + scheme + ".compatibility.privileged.user";
        String privileged = this.conf.get(key, null);
        return privileged != null ? privileged : this.conf.get("dfs.permissions.superusergroup", "supergroup");
    }

    public String[] getStoragePolicyNames() {
        String scheme = this.uri.toUri().getScheme();
        String key = "fs." + scheme + ".compatibility.storage.policies";
        String storagePolicies = this.conf.get(key, null);
        return storagePolicies != null ? storagePolicies.split(",") : (String[])this.defaultStoragePolicyNames.clone();
    }

    public String getDelegationTokenRenewer() {
        String scheme = this.uri.toUri().getScheme();
        String key = "fs." + scheme + ".compatibility.delegation.token.renewer";
        return this.conf.get(key, "");
    }

    private String getEnvTmpDir() {
        String systemDefault = System.getProperty("java.io.tmpdir");
        if (systemDefault == null || systemDefault.isEmpty()) {
            return null;
        }
        String[] tmpDirs = systemDefault.split(",|" + File.pathSeparator);
        List validDirs = Arrays.stream(tmpDirs).filter(s -> s != null && !s.isEmpty()).collect(Collectors.toList());
        if (validDirs.isEmpty()) {
            return null;
        }
        String tmpDir = (String)validDirs.get(RANDOM.nextInt(validDirs.size()));
        return new File(tmpDir).getAbsolutePath();
    }

    private String[] getDefaultStoragePolicyNames() {
        Collection policies = null;
        try {
            policies = this.fs.getAllStoragePolicies();
        }
        catch (Exception e) {
            LOG.warn("Cannot get storage policy", (Throwable)e);
        }
        if (policies == null || policies.isEmpty()) {
            return new String[]{"Hot"};
        }
        return (String[])policies.stream().map(BlockStoragePolicySpi::getName).toArray(String[]::new);
    }
}

