/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.common;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.compat.common.HdfsCompatApiScope;
import org.apache.hadoop.fs.compat.common.HdfsCompatEnvironment;
import org.apache.hadoop.fs.compat.common.HdfsCompatIllegalArgumentException;
import org.apache.hadoop.fs.compat.common.HdfsCompatReport;
import org.apache.hadoop.fs.compat.common.HdfsCompatShellScope;
import org.apache.hadoop.fs.compat.common.HdfsCompatSuite;
import org.apache.hadoop.fs.compat.suites.HdfsCompatSuiteForAll;
import org.apache.hadoop.fs.compat.suites.HdfsCompatSuiteForShell;
import org.apache.hadoop.fs.compat.suites.HdfsCompatSuiteForTpcds;

public class HdfsCompatCommand {
    private final Path uri;
    private final String suiteName;
    private final Configuration conf;
    private HdfsCompatSuite suite;
    private HdfsCompatApiScope api;
    private HdfsCompatShellScope shell;

    public HdfsCompatCommand(String uri, String suiteName, Configuration conf) {
        this.uri = new Path(uri);
        this.suiteName = suiteName.toLowerCase();
        this.conf = conf;
    }

    public void initialize() throws ReflectiveOperationException, IOException {
        this.initSuite();
        HdfsCompatEnvironment env = new HdfsCompatEnvironment(this.uri, this.conf);
        env.init();
        if (this.hasApiCase()) {
            this.api = new HdfsCompatApiScope(env, this.suite);
        }
        if (this.hasShellCase()) {
            this.shell = new HdfsCompatShellScope(env, this.suite);
        }
    }

    public HdfsCompatReport apply() throws Exception {
        HdfsCompatReport report = new HdfsCompatReport(this.uri.toString(), this.suite);
        if (this.api != null) {
            report.merge(this.api.apply());
        }
        if (this.shell != null) {
            report.merge(this.shell.apply());
        }
        return report;
    }

    private void initSuite() throws ReflectiveOperationException {
        Map<String, HdfsCompatSuite> defaultSuites = this.getDefaultSuites();
        this.suite = defaultSuites.getOrDefault(this.suiteName, null);
        if (this.suite != null) {
            return;
        }
        String key = "hadoop.compatibility.suite." + this.suiteName + ".classname";
        String suiteClassName = this.conf.get(key, null);
        if (suiteClassName == null || suiteClassName.isEmpty()) {
            throw new HdfsCompatIllegalArgumentException("cannot get class name for suite " + this.suiteName + ", configuration " + key + " is not properly set.");
        }
        Constructor<?> ctor = suiteClassName.getClass().getConstructor(new Class[0]);
        ctor.setAccessible(true);
        Object suiteObj = ctor.newInstance(new Object[0]);
        if (!(suiteObj instanceof HdfsCompatSuite)) {
            throw new HdfsCompatIllegalArgumentException("class name " + suiteClassName + " must be an implementation of " + HdfsCompatSuite.class.getName());
        }
        this.suite = (HdfsCompatSuite)suiteObj;
        if (this.suite.getSuiteName() == null || this.suite.getSuiteName().isEmpty()) {
            throw new HdfsCompatIllegalArgumentException("suite " + suiteClassName + " suiteName is empty");
        }
        for (HdfsCompatSuite defaultSuite : defaultSuites.values()) {
            if (!this.suite.getSuiteName().equalsIgnoreCase(defaultSuite.getSuiteName())) continue;
            throw new HdfsCompatIllegalArgumentException("suite " + suiteClassName + " suiteName conflicts with default suite " + defaultSuite.getSuiteName());
        }
        if (!this.hasApiCase() && !this.hasShellCase()) {
            throw new HdfsCompatIllegalArgumentException("suite " + suiteClassName + " is empty for both API and SHELL");
        }
    }

    private boolean hasApiCase() {
        return this.suite.getApiCases() != null && this.suite.getApiCases().length > 0;
    }

    private boolean hasShellCase() {
        return this.suite.getShellCases() != null && this.suite.getShellCases().length > 0;
    }

    @VisibleForTesting
    protected Map<String, HdfsCompatSuite> getDefaultSuites() {
        HashMap<String, HdfsCompatSuite> defaultSuites = new HashMap<String, HdfsCompatSuite>();
        defaultSuites.put("all", new HdfsCompatSuiteForAll());
        defaultSuites.put("shell", new HdfsCompatSuiteForShell());
        defaultSuites.put("tpcds", new HdfsCompatSuiteForTpcds());
        return defaultSuites;
    }
}

