/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.compat.HdfsCompatTool;
import org.apache.hadoop.fs.compat.common.AbstractHdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseCleanup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseGroup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCasePrepare;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseSetUp;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseTearDown;
import org.apache.hadoop.fs.compat.common.HdfsCompatEnvironment;
import org.apache.hadoop.fs.compat.common.HdfsCompatIllegalCaseException;
import org.apache.hadoop.fs.compat.common.HdfsCompatReport;
import org.apache.hadoop.fs.compat.common.HdfsCompatSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsCompatApiScope {
    static final boolean SKIP_NO_SUCH_METHOD_ERROR = true;
    private static final Logger LOG = LoggerFactory.getLogger(HdfsCompatApiScope.class);
    private final HdfsCompatEnvironment env;
    private final HdfsCompatSuite suite;

    public HdfsCompatApiScope(HdfsCompatEnvironment env, HdfsCompatSuite suite) {
        this.env = env;
        this.suite = suite;
    }

    public HdfsCompatReport apply() {
        List<GroupedCase> groups = this.collectGroup();
        HdfsCompatReport report = new HdfsCompatReport();
        for (GroupedCase group : groups) {
            if (group.methods.isEmpty()) continue;
            AbstractHdfsCompatCase obj = group.obj;
            GroupedResult groupedResult = new GroupedResult(obj, group.methods);
            groupedResult.setUp = this.test(group.setUp, obj);
            if (groupedResult.setUp == Result.OK) {
                for (Method method : group.methods) {
                    CaseResult caseResult = new CaseResult();
                    caseResult.prepareResult = this.test(group.prepare, obj);
                    if (caseResult.prepareResult == Result.OK) {
                        caseResult.methodResult = this.test(method, obj);
                    }
                    caseResult.cleanupResult = this.test(group.cleanup, obj);
                    groupedResult.results.put(HdfsCompatApiScope.getCaseName(method), caseResult);
                }
            }
            groupedResult.tearDown = this.test(group.tearDown, obj);
            groupedResult.exportTo(report);
        }
        return report;
    }

    private Result test(Method method, AbstractHdfsCompatCase obj) {
        if (method == null) {
            return Result.OK;
        }
        try {
            method.invoke((Object)obj, new Object[0]);
            return Result.OK;
        }
        catch (InvocationTargetException t) {
            Throwable e = t.getCause();
            if (e instanceof NoSuchMethodError) {
                LOG.warn("Case skipped with method " + method.getName() + " of class " + obj.getClass(), e);
                return Result.SKIP;
            }
            LOG.warn("Case failed with method " + method.getName() + " of class " + obj.getClass(), e);
            return Result.ERROR;
        }
        catch (ReflectiveOperationException e) {
            LOG.error("Illegal Compatibility Case method " + method.getName() + " of class " + obj.getClass(), (Throwable)e);
            throw new HdfsCompatIllegalCaseException(e.getMessage());
        }
    }

    private List<GroupedCase> collectGroup() {
        Class<? extends AbstractHdfsCompatCase>[] cases = this.suite.getApiCases();
        ArrayList<GroupedCase> groups = new ArrayList<GroupedCase>();
        for (Class<? extends AbstractHdfsCompatCase> cls : cases) {
            try {
                groups.add(GroupedCase.parse(cls, this.env));
            }
            catch (ReflectiveOperationException e) {
                LOG.error("Illegal Compatibility Group " + cls.getName(), (Throwable)e);
                throw new HdfsCompatIllegalCaseException(e.getMessage());
            }
        }
        return groups;
    }

    private static String getCaseName(Method caseMethod) {
        HdfsCompatCase annotation = caseMethod.getAnnotation(HdfsCompatCase.class);
        assert (annotation != null);
        if (annotation.brief().isEmpty()) {
            return caseMethod.getName();
        }
        return caseMethod.getName() + " (" + annotation.brief() + ")";
    }

    @VisibleForTesting
    public static Set<String> getPublicInterfaces(Class<?> cls) {
        Method[] methods = cls.getDeclaredMethods();
        HashSet<String> publicMethodNames = new HashSet<String>();
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
            publicMethodNames.add(method.getName());
        }
        publicMethodNames.remove(cls.getSimpleName());
        publicMethodNames.remove("toString");
        return publicMethodNames;
    }

    private static final class GroupedCase {
        private static final Map<String, Set<String>> DEFINED_METHODS = new HashMap<String, Set<String>>();
        private final AbstractHdfsCompatCase obj;
        private final List<Method> methods;
        private final Method setUp;
        private final Method tearDown;
        private final Method prepare;
        private final Method cleanup;

        private GroupedCase(AbstractHdfsCompatCase obj, List<Method> methods, Method setUp, Method tearDown, Method prepare, Method cleanup) {
            this.obj = obj;
            this.methods = methods;
            this.setUp = setUp;
            this.tearDown = tearDown;
            this.prepare = prepare;
            this.cleanup = cleanup;
        }

        private static GroupedCase parse(Class<? extends AbstractHdfsCompatCase> cls, HdfsCompatEnvironment env) throws ReflectiveOperationException {
            Constructor<? extends AbstractHdfsCompatCase> ctor = cls.getConstructor(new Class[0]);
            ctor.setAccessible(true);
            AbstractHdfsCompatCase caseObj = ctor.newInstance(new Object[0]);
            caseObj.init(env);
            Method[] declaredMethods = caseObj.getClass().getDeclaredMethods();
            ArrayList<Method> caseMethods = new ArrayList<Method>();
            Method setUp = null;
            Method tearDown = null;
            Method prepare = null;
            Method cleanup = null;
            for (Method method : declaredMethods) {
                if (method.isAnnotationPresent(HdfsCompatCase.class)) {
                    if (method.isAnnotationPresent(HdfsCompatCaseSetUp.class) || method.isAnnotationPresent(HdfsCompatCaseTearDown.class) || method.isAnnotationPresent(HdfsCompatCasePrepare.class) || method.isAnnotationPresent(HdfsCompatCaseCleanup.class)) {
                        throw new HdfsCompatIllegalCaseException("Compatibility Case must not be annotated by Prepare/Cleanup or SetUp/TearDown");
                    }
                    HdfsCompatCase annotation = method.getAnnotation(HdfsCompatCase.class);
                    if (annotation.ifDef().isEmpty()) {
                        caseMethods.add(method);
                        continue;
                    }
                    String[] requireDefined = annotation.ifDef().split(",");
                    if (!Arrays.stream(requireDefined).allMatch(GroupedCase::checkDefined)) continue;
                    caseMethods.add(method);
                    continue;
                }
                if (method.isAnnotationPresent(HdfsCompatCaseSetUp.class)) {
                    if (setUp != null) {
                        throw new HdfsCompatIllegalCaseException("Duplicate SetUp method in Compatibility Case");
                    }
                    setUp = method;
                }
                if (method.isAnnotationPresent(HdfsCompatCaseTearDown.class)) {
                    if (tearDown != null) {
                        throw new HdfsCompatIllegalCaseException("Duplicate TearDown method in Compatibility Case");
                    }
                    tearDown = method;
                }
                if (method.isAnnotationPresent(HdfsCompatCasePrepare.class)) {
                    if (prepare != null) {
                        throw new HdfsCompatIllegalCaseException("Duplicate Prepare method in Compatibility Case");
                    }
                    prepare = method;
                }
                if (!method.isAnnotationPresent(HdfsCompatCaseCleanup.class)) continue;
                if (cleanup != null) {
                    throw new HdfsCompatIllegalCaseException("Duplicate Cleanup method in Compatibility Case");
                }
                cleanup = method;
            }
            return new GroupedCase(caseObj, caseMethods, setUp, tearDown, prepare, cleanup);
        }

        private static synchronized boolean checkDefined(String ifDef) {
            Class<?> cls;
            String[] classAndMethod = ifDef.split("#", 2);
            if (classAndMethod.length < 2) {
                throw new HdfsCompatIllegalCaseException("ifDef must be with format className#methodName");
            }
            String className = classAndMethod[0];
            String methodName = classAndMethod[1];
            Set<String> methods = DEFINED_METHODS.getOrDefault(className, null);
            if (methods != null) {
                return methods.contains(methodName);
            }
            try {
                cls = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new HdfsCompatIllegalCaseException(e.getMessage());
            }
            methods = HdfsCompatApiScope.getPublicInterfaces(cls);
            DEFINED_METHODS.put(className, methods);
            return methods.contains(methodName);
        }
    }

    private static final class GroupedResult {
        private static final int COMMON_PREFIX_LEN = HdfsCompatTool.class.getPackage().getName().length() + ".cases.".length();
        private final String prefix;
        private Result setUp;
        private Result tearDown;
        private final LinkedHashMap<String, CaseResult> results;

        private GroupedResult(AbstractHdfsCompatCase obj, List<Method> methods) {
            this.prefix = GroupedResult.getNamePrefix(obj.getClass());
            this.results = new LinkedHashMap();
            for (Method method : methods) {
                this.results.put(HdfsCompatApiScope.getCaseName(method), new CaseResult());
            }
        }

        private void exportTo(HdfsCompatReport report) {
            if (this.setUp == Result.SKIP) {
                List<String> cases = this.results.keySet().stream().map(m -> this.prefix + m).collect(Collectors.toList());
                report.addSkippedCase(cases);
                return;
            }
            if (this.setUp == Result.ERROR || this.tearDown == Result.ERROR) {
                List<String> cases = this.results.keySet().stream().map(m -> this.prefix + m).collect(Collectors.toList());
                report.addFailedCase(cases);
                return;
            }
            ArrayList<String> passed = new ArrayList<String>();
            ArrayList<String> failed = new ArrayList<String>();
            ArrayList<String> skipped = new ArrayList<String>();
            for (Map.Entry<String, CaseResult> entry : this.results.entrySet()) {
                String caseName = this.prefix + entry.getKey();
                CaseResult result = entry.getValue();
                if (result.prepareResult == Result.SKIP) {
                    skipped.add(caseName);
                    continue;
                }
                if (result.prepareResult == Result.ERROR || result.cleanupResult == Result.ERROR || result.methodResult == Result.ERROR) {
                    failed.add(caseName);
                    continue;
                }
                if (result.methodResult == Result.OK) {
                    passed.add(caseName);
                    continue;
                }
                skipped.add(caseName);
            }
            if (!passed.isEmpty()) {
                report.addPassedCase(passed);
            }
            if (!failed.isEmpty()) {
                report.addFailedCase(failed);
            }
            if (!skipped.isEmpty()) {
                report.addSkippedCase(skipped);
            }
        }

        private static String getNamePrefix(Class<? extends AbstractHdfsCompatCase> cls) {
            return (cls.getPackage().getName() + ".").substring(COMMON_PREFIX_LEN) + GroupedResult.getGroupName(cls) + ".";
        }

        private static String getGroupName(Class<? extends AbstractHdfsCompatCase> cls) {
            HdfsCompatCaseGroup annotation;
            if (cls.isAnnotationPresent(HdfsCompatCaseGroup.class) && !(annotation = cls.getAnnotation(HdfsCompatCaseGroup.class)).name().isEmpty()) {
                return annotation.name();
            }
            return cls.getSimpleName();
        }
    }

    private static enum Result {
        OK,
        ERROR,
        SKIP;

    }

    private static class CaseResult {
        private Result prepareResult = Result.SKIP;
        private Result cleanupResult = Result.SKIP;
        private Result methodResult = Result.SKIP;

        private CaseResult() {
        }
    }
}

