/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.common;

import java.util.Random;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.compat.common.HdfsCompatEnvironment;

public abstract class AbstractHdfsCompatCase {
    private static final Random RANDOM = new Random();
    private FileSystem fs;
    private HdfsCompatEnvironment env;
    private Path localPath;

    public void init(HdfsCompatEnvironment environment) {
        this.env = environment;
        this.fs = this.env.getFileSystem();
        LocalFileSystem localFs = this.env.getLocalFileSystem();
        this.localPath = localFs.makeQualified(new Path(this.env.getLocalTmpDir()));
    }

    public FileSystem fs() {
        return this.fs;
    }

    public Path getRootPath() {
        return this.env.getRoot();
    }

    public Path getBasePath() {
        return this.env.getBase();
    }

    public Path getUniquePath() {
        return AbstractHdfsCompatCase.getUniquePath(this.getBasePath());
    }

    public static Path getUniquePath(Path basePath) {
        return new Path(basePath, System.currentTimeMillis() + "_" + RANDOM.nextLong());
    }

    public Path makePath(String name) {
        return new Path(this.getUniquePath(), name);
    }

    public Path getLocalPath() {
        return this.localPath;
    }

    public String getPrivilegedUser() {
        return this.env.getPrivilegedUser();
    }

    public String[] getStoragePolicyNames() {
        return this.env.getStoragePolicyNames();
    }

    public String getDelegationTokenRenewer() {
        return this.env.getDelegationTokenRenewer();
    }
}

