/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.cases;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.compat.common.AbstractHdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseCleanup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseGroup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCasePrepare;
import org.apache.hadoop.fs.compat.common.HdfsCompatUtil;
import org.junit.jupiter.api.Assertions;

@HdfsCompatCaseGroup(name="XAttr")
public class HdfsCompatXAttr
extends AbstractHdfsCompatCase {
    private Path file;

    @HdfsCompatCasePrepare
    public void prepare() throws IOException {
        this.file = this.makePath("file");
        HdfsCompatUtil.createFile(this.fs(), this.file, 0L);
    }

    @HdfsCompatCaseCleanup
    public void cleanup() {
        HdfsCompatUtil.deleteQuietly(this.fs(), this.file, true);
    }

    @HdfsCompatCase
    public void setXAttr() throws IOException {
        String key = "user.key";
        byte[] value = "value".getBytes(StandardCharsets.UTF_8);
        this.fs().setXAttr(this.file, "user.key", value);
        Map attrs = this.fs().getXAttrs(this.file);
        Assertions.assertArrayEquals((byte[])value, (byte[])attrs.getOrDefault("user.key", new byte[0]));
    }

    @HdfsCompatCase
    public void getXAttr() throws IOException {
        String key = "user.key";
        byte[] value = "value".getBytes(StandardCharsets.UTF_8);
        this.fs().setXAttr(this.file, "user.key", value);
        byte[] attr = this.fs().getXAttr(this.file, "user.key");
        Assertions.assertArrayEquals((byte[])value, (byte[])attr);
    }

    @HdfsCompatCase
    public void getXAttrs() throws IOException {
        this.fs().setXAttr(this.file, "user.key1", "value1".getBytes(StandardCharsets.UTF_8));
        this.fs().setXAttr(this.file, "user.key2", "value2".getBytes(StandardCharsets.UTF_8));
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("user.key1");
        Map attrs = this.fs().getXAttrs(this.file, keys);
        Assertions.assertEquals((int)1, (int)attrs.size());
        byte[] attr = attrs.getOrDefault("user.key1", new byte[0]);
        Assertions.assertArrayEquals((byte[])"value1".getBytes(StandardCharsets.UTF_8), (byte[])attr);
    }

    @HdfsCompatCase
    public void listXAttrs() throws IOException {
        this.fs().setXAttr(this.file, "user.key1", "value1".getBytes(StandardCharsets.UTF_8));
        this.fs().setXAttr(this.file, "user.key2", "value2".getBytes(StandardCharsets.UTF_8));
        List names = this.fs().listXAttrs(this.file);
        Assertions.assertEquals((int)2, (int)names.size());
        Assertions.assertTrue((boolean)names.contains("user.key1"));
        Assertions.assertTrue((boolean)names.contains("user.key2"));
    }

    @HdfsCompatCase
    public void removeXAttr() throws IOException {
        this.fs().setXAttr(this.file, "user.key1", "value1".getBytes(StandardCharsets.UTF_8));
        this.fs().setXAttr(this.file, "user.key2", "value2".getBytes(StandardCharsets.UTF_8));
        this.fs().removeXAttr(this.file, "user.key1");
        List names = this.fs().listXAttrs(this.file);
        Assertions.assertEquals((int)1, (int)names.size());
        Assertions.assertTrue((boolean)names.contains("user.key2"));
    }
}

