/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.cases;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.compat.common.AbstractHdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseCleanup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseGroup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCasePrepare;
import org.apache.hadoop.fs.compat.common.HdfsCompatUtil;
import org.junit.jupiter.api.Assertions;

@HdfsCompatCaseGroup(name="TPCDS")
public class HdfsCompatTpcds
extends AbstractHdfsCompatCase {
    private static final int FILE_LEN = 8;
    private static final Random RANDOM = new Random();
    private Path path = null;

    @HdfsCompatCasePrepare
    public void prepare() throws IOException {
        this.path = this.makePath("path");
    }

    @HdfsCompatCaseCleanup
    public void cleanup() throws IOException {
        HdfsCompatUtil.deleteQuietly(this.fs(), this.path, true);
    }

    @HdfsCompatCase
    public void open() throws IOException {
        HdfsCompatUtil.createFile(this.fs(), this.path, 8L);
        byte[] data = new byte[8];
        try (FSDataInputStream in = this.fs().open(this.path);){
            in.readFully(data);
        }
    }

    @HdfsCompatCase
    public void create() throws IOException {
        byte[] data = new byte[8];
        RANDOM.nextBytes(data);
        try (FSDataOutputStream out = this.fs().create(this.path, true);){
            out.write(data);
        }
    }

    @HdfsCompatCase
    public void mkdirs() throws IOException {
        Assertions.assertTrue((boolean)this.fs().mkdirs(this.path));
    }

    @HdfsCompatCase
    public void getFileStatus() throws IOException {
        HdfsCompatUtil.createFile(this.fs(), this.path, 8L);
        FileStatus fileStatus = this.fs().getFileStatus(this.path);
        Assertions.assertEquals((long)8L, (long)fileStatus.getLen());
    }

    @HdfsCompatCase
    public void listStatus() throws IOException {
        HdfsCompatUtil.createFile(this.fs(), new Path(this.path, "file"), 8L);
        FileStatus[] files = this.fs().listStatus(this.path);
        Assertions.assertEquals((int)1, (int)files.length);
        Assertions.assertEquals((long)8L, (long)files[0].getLen());
    }

    @HdfsCompatCase
    public void listLocatedStatus() throws IOException {
        HdfsCompatUtil.createFile(this.fs(), new Path(this.path, "file"), 8L);
        RemoteIterator it = this.fs().listLocatedStatus(this.path);
        ArrayList<LocatedFileStatus> files = new ArrayList<LocatedFileStatus>();
        while (it.hasNext()) {
            files.add((LocatedFileStatus)it.next());
        }
        Assertions.assertEquals((int)1, (int)files.size());
        Assertions.assertEquals((long)8L, (long)((LocatedFileStatus)files.get(0)).getLen());
    }

    @HdfsCompatCase
    public void rename() throws IOException {
        HdfsCompatUtil.createFile(this.fs(), new Path(this.path, "file"), 8L);
        this.fs().rename(this.path, new Path(this.path.getParent(), this.path.getName() + "_dst"));
    }

    @HdfsCompatCase
    public void delete() throws IOException {
        HdfsCompatUtil.createFile(this.fs(), new Path(this.path, "file"), 8L);
        this.fs().delete(this.path, true);
    }

    @HdfsCompatCase
    public void getServerDefaults() throws IOException {
        Assertions.assertNotNull((Object)this.fs().getServerDefaults(this.path));
    }

    @HdfsCompatCase
    public void getTrashRoot() throws IOException {
        Assertions.assertNotNull((Object)this.fs().getTrashRoot(this.path));
    }

    @HdfsCompatCase
    public void makeQualified() throws IOException {
        Assertions.assertNotNull((Object)this.fs().makeQualified(this.path));
    }
}

