/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.cases;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.compat.common.AbstractHdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseCleanup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseGroup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCasePrepare;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseSetUp;
import org.apache.hadoop.fs.compat.common.HdfsCompatUtil;
import org.junit.jupiter.api.Assertions;

@HdfsCompatCaseGroup(name="Symlink")
public class HdfsCompatSymlink
extends AbstractHdfsCompatCase {
    private static final int FILE_LEN = 128;
    private Path target = null;
    private Path link = null;

    @HdfsCompatCaseSetUp
    public void setUp() {
        FileSystem.enableSymlinks();
    }

    @HdfsCompatCasePrepare
    public void prepare() throws IOException {
        this.target = this.makePath("target");
        this.link = new Path(this.target.getParent(), "link");
        HdfsCompatUtil.createFile(this.fs(), this.target, 128L);
        this.fs().createSymlink(this.target, this.link, true);
    }

    @HdfsCompatCaseCleanup
    public void cleanup() throws IOException {
        HdfsCompatUtil.deleteQuietly(this.fs(), this.link, true);
        HdfsCompatUtil.deleteQuietly(this.fs(), this.target, true);
    }

    @HdfsCompatCase
    public void createSymlink() throws IOException {
        Assertions.assertTrue((boolean)this.fs().exists(this.link));
    }

    @HdfsCompatCase
    public void getFileLinkStatus() throws IOException {
        FileStatus linkStatus = this.fs().getFileLinkStatus(this.link);
        Assertions.assertTrue((boolean)linkStatus.isSymlink());
        Assertions.assertEquals((Object)this.target.getName(), (Object)linkStatus.getSymlink().getName());
    }

    @HdfsCompatCase
    public void getLinkTarget() throws IOException {
        Path src = this.fs().getLinkTarget(this.link);
        Assertions.assertEquals((Object)this.target.getName(), (Object)src.getName());
    }
}

