/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.cases;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.compat.common.AbstractHdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseCleanup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseGroup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCasePrepare;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseSetUp;
import org.apache.hadoop.fs.compat.common.HdfsCompatUtil;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HdfsCompatCaseGroup(name="StoragePolicy")
public class HdfsCompatStoragePolicy
extends AbstractHdfsCompatCase {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsCompatStoragePolicy.class);
    private static final Random RANDOM = new Random();
    private Path dir;
    private Path file;
    private String[] policies;
    private String defaultPolicyName;
    private String policyName;

    @HdfsCompatCaseSetUp
    public void setUp() throws IOException {
        this.policies = this.getStoragePolicyNames();
    }

    @HdfsCompatCasePrepare
    public void prepare() throws IOException {
        this.dir = this.makePath("dir");
        this.file = new Path(this.dir, "file");
        HdfsCompatUtil.createFile(this.fs(), this.file, 0L);
        BlockStoragePolicySpi policy = this.fs().getStoragePolicy(this.dir);
        this.defaultPolicyName = policy == null ? null : policy.getName();
        ArrayList<String> differentPolicies = new ArrayList<String>();
        for (String name : this.policies) {
            if (name.equalsIgnoreCase(this.defaultPolicyName)) continue;
            differentPolicies.add(name);
        }
        if (differentPolicies.isEmpty()) {
            LOG.warn("There is only one storage policy: " + (this.defaultPolicyName == null ? "null" : this.defaultPolicyName));
            this.policyName = this.defaultPolicyName;
        } else {
            this.policyName = (String)differentPolicies.get(RANDOM.nextInt(differentPolicies.size()));
        }
    }

    @HdfsCompatCaseCleanup
    public void cleanup() {
        HdfsCompatUtil.deleteQuietly(this.fs(), this.dir, true);
    }

    @HdfsCompatCase
    public void setStoragePolicy() throws IOException {
        this.fs().setStoragePolicy(this.dir, this.policyName);
        BlockStoragePolicySpi policy = this.fs().getStoragePolicy(this.dir);
        Assertions.assertEquals((Object)this.policyName, (Object)policy.getName());
    }

    @HdfsCompatCase
    public void unsetStoragePolicy() throws IOException {
        this.fs().setStoragePolicy(this.dir, this.policyName);
        this.fs().unsetStoragePolicy(this.dir);
        BlockStoragePolicySpi policy = this.fs().getStoragePolicy(this.dir);
        String policyNameAfterUnset = policy == null ? null : policy.getName();
        Assertions.assertEquals((Object)this.defaultPolicyName, (Object)policyNameAfterUnset);
    }

    @HdfsCompatCase(ifDef="org.apache.hadoop.fs.FileSystem#satisfyStoragePolicy")
    public void satisfyStoragePolicy() throws IOException {
        this.fs().setStoragePolicy(this.dir, this.policyName);
        this.fs().satisfyStoragePolicy(this.dir);
    }

    @HdfsCompatCase
    public void getStoragePolicy() throws IOException {
        BlockStoragePolicySpi policy = this.fs().getStoragePolicy(this.file);
        String initialPolicyName = policy == null ? null : policy.getName();
        Assertions.assertEquals((Object)this.defaultPolicyName, (Object)initialPolicyName);
    }
}

