/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.cases;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.compat.common.AbstractHdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseCleanup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseGroup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCasePrepare;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseSetUp;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseTearDown;
import org.apache.hadoop.fs.compat.common.HdfsCompatUtil;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HdfsCompatCaseGroup(name="Snapshot")
public class HdfsCompatSnapshot
extends AbstractHdfsCompatCase {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsCompatSnapshot.class);
    private final String snapshotName = "s-name";
    private final String fileName = "file";
    private Path base;
    private Path dir;
    private Path snapshot;
    private Method allow;
    private Method disallow;

    private static Path getSnapshotPath(Path path, String snapshotName) {
        return new Path(path, ".snapshot/" + snapshotName);
    }

    @HdfsCompatCaseSetUp
    public void setUp() throws Exception {
        block5: {
            this.base = this.getUniquePath();
            this.fs().mkdirs(this.base);
            try {
                Method allowSnapshotMethod = this.fs().getClass().getMethod("allowSnapshot", Path.class);
                allowSnapshotMethod.setAccessible(true);
                allowSnapshotMethod.invoke((Object)this.fs(), this.base);
                this.allow = allowSnapshotMethod;
                Method disallowSnapshotMethod = this.fs().getClass().getMethod("disallowSnapshot", Path.class);
                disallowSnapshotMethod.setAccessible(true);
                disallowSnapshotMethod.invoke((Object)this.fs(), this.base);
                this.disallow = disallowSnapshotMethod;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw new RuntimeException(cause);
            }
            catch (ReflectiveOperationException e) {
                if (this.allow == null) {
                    LOG.warn("No allowSnapshot method found.");
                }
                if (this.disallow != null) break block5;
                LOG.warn("No disallowSnapshot method found.");
            }
        }
    }

    @HdfsCompatCaseTearDown
    public void tearDown() throws ReflectiveOperationException {
        try {
            if (this.disallow != null) {
                this.disallow.invoke((Object)this.fs(), this.base);
            }
        }
        finally {
            HdfsCompatUtil.deleteQuietly(this.fs(), this.base, true);
        }
    }

    @HdfsCompatCasePrepare
    public void prepare() throws IOException, ReflectiveOperationException {
        this.dir = HdfsCompatSnapshot.getUniquePath(this.base);
        HdfsCompatUtil.createFile(this.fs(), new Path(this.dir, this.fileName), 0L);
        if (this.allow != null) {
            this.allow.invoke((Object)this.fs(), this.dir);
        }
        this.snapshot = this.fs().createSnapshot(this.dir, this.snapshotName);
    }

    @HdfsCompatCaseCleanup
    public void cleanup() throws ReflectiveOperationException {
        try {
            try {
                this.fs().deleteSnapshot(this.dir, this.snapshotName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.disallow != null) {
                this.disallow.invoke((Object)this.fs(), this.dir);
            }
        }
        finally {
            HdfsCompatUtil.deleteQuietly(this.fs(), this.dir, true);
        }
    }

    @HdfsCompatCase
    public void createSnapshot() throws IOException {
        Assertions.assertNotEquals((Object)this.snapshot.toString(), (Object)this.dir.toString());
        Assertions.assertTrue((boolean)this.fs().exists(this.snapshot));
        Assertions.assertTrue((boolean)this.fs().exists(new Path(this.snapshot, "file")));
    }

    @HdfsCompatCase
    public void renameSnapshot() throws IOException {
        this.fs().renameSnapshot(this.dir, "s-name", "s-name2");
        Assertions.assertFalse((boolean)this.fs().exists(new Path(this.snapshot, "file")));
        this.snapshot = HdfsCompatSnapshot.getSnapshotPath(this.dir, "s-name2");
        Assertions.assertTrue((boolean)this.fs().exists(new Path(this.snapshot, "file")));
        this.fs().renameSnapshot(this.dir, "s-name2", "s-name");
    }

    @HdfsCompatCase
    public void deleteSnapshot() throws IOException {
        this.fs().deleteSnapshot(this.dir, "s-name");
        Assertions.assertFalse((boolean)this.fs().exists(this.snapshot));
        Assertions.assertFalse((boolean)this.fs().exists(new Path(this.snapshot, "file")));
    }
}

