/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.cases;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.compat.common.AbstractHdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseGroup;
import org.apache.hadoop.fs.compat.common.HdfsCompatUtil;
import org.junit.jupiter.api.Assertions;

@HdfsCompatCaseGroup(name="Server")
public class HdfsCompatServer
extends AbstractHdfsCompatCase {
    private void isValid(String name) {
        Assertions.assertNotNull((Object)name);
        Assertions.assertFalse((boolean)name.isEmpty());
    }

    @HdfsCompatCase
    public void initialize() throws Exception {
        Class cls = FileSystem.getFileSystemClass((String)this.getBasePath().toUri().getScheme(), (Configuration)this.fs().getConf());
        Constructor ctor = cls.getDeclaredConstructor(new Class[0]);
        ctor.setAccessible(true);
        FileSystem newFs = (FileSystem)ctor.newInstance(new Object[0]);
        newFs.initialize(this.fs().getUri(), this.fs().getConf());
    }

    @HdfsCompatCase
    public void getScheme() {
        String scheme = this.fs().getScheme();
        this.isValid(scheme);
    }

    @HdfsCompatCase
    public void getUri() {
        URI uri = this.fs().getUri();
        this.isValid(uri.getScheme());
    }

    @HdfsCompatCase
    public void getCanonicalServiceName() {
        String serviceName = this.fs().getCanonicalServiceName();
        this.isValid(serviceName);
    }

    @HdfsCompatCase
    public void getName() {
        String name = this.fs().getName();
        this.isValid(name);
    }

    @HdfsCompatCase
    public void makeQualified() {
        Path path = this.fs().makeQualified(this.makePath("file"));
        this.isValid(path.toUri().getScheme());
    }

    @HdfsCompatCase
    public void getChildFileSystems() {
        this.fs().getChildFileSystems();
    }

    @HdfsCompatCase
    public void resolvePath() throws IOException {
        FileSystem.enableSymlinks();
        Path file = this.makePath("file");
        Path link = new Path(file.toString() + "_link");
        HdfsCompatUtil.createFile(this.fs(), file, 0L);
        this.fs().createSymlink(file, link, true);
        Path resolved = this.fs().resolvePath(link);
        Assertions.assertEquals((Object)file.getName(), (Object)resolved.getName());
    }

    @HdfsCompatCase
    public void getHomeDirectory() {
        Path home = this.fs().getHomeDirectory();
        this.isValid(home.toString());
    }

    @HdfsCompatCase
    public void setWorkingDirectory() throws IOException {
        FileSystem another = FileSystem.newInstance((URI)this.fs().getUri(), (Configuration)this.fs().getConf());
        Path work = this.makePath("work");
        another.setWorkingDirectory(work);
        Assertions.assertEquals((Object)work.getName(), (Object)another.getWorkingDirectory().getName());
    }

    @HdfsCompatCase
    public void getWorkingDirectory() {
        Path work = this.fs().getWorkingDirectory();
        this.isValid(work.toString());
    }

    @HdfsCompatCase
    public void close() throws IOException {
        FileSystem another = FileSystem.newInstance((URI)this.fs().getUri(), (Configuration)this.fs().getConf());
        another.close();
    }

    @HdfsCompatCase
    public void getDefaultBlockSize() {
        Assertions.assertTrue((this.fs().getDefaultBlockSize(this.getBasePath()) >= 0L ? 1 : 0) != 0);
    }

    @HdfsCompatCase
    public void getDefaultReplication() {
        Assertions.assertTrue((this.fs().getDefaultReplication(this.getBasePath()) >= 0 ? 1 : 0) != 0);
    }

    @HdfsCompatCase
    public void getStorageStatistics() {
        Assertions.assertNotNull((Object)this.fs().getStorageStatistics());
    }

    public void setVerifyChecksum() {
    }

    public void setWriteChecksum() {
    }

    @HdfsCompatCase
    public void getDelegationToken() throws IOException {
        Assertions.assertNotNull((Object)this.fs().getDelegationToken(this.getDelegationTokenRenewer()));
    }

    @HdfsCompatCase
    public void getAdditionalTokenIssuers() throws IOException {
        Assertions.assertNotNull((Object)this.fs().getAdditionalTokenIssuers());
    }

    @HdfsCompatCase
    public void getServerDefaults() throws IOException {
        FsServerDefaults d = this.fs().getServerDefaults(this.getBasePath());
        Assertions.assertTrue((d.getBlockSize() >= 0L ? 1 : 0) != 0);
    }

    @HdfsCompatCase
    public void msync() throws IOException {
        this.fs().msync();
    }

    @HdfsCompatCase
    public void getStatus() throws IOException {
        FsStatus status = this.fs().getStatus();
        Assertions.assertTrue((status.getRemaining() > 0L ? 1 : 0) != 0);
    }

    @HdfsCompatCase
    public void getTrashRoot() {
        Path trash = this.fs().getTrashRoot(this.makePath("file"));
        this.isValid(trash.toString());
    }

    @HdfsCompatCase
    public void getTrashRoots() {
        Collection trashes = this.fs().getTrashRoots(true);
        Assertions.assertNotNull((Object)trashes);
        for (FileStatus trash : trashes) {
            this.isValid(trash.getPath().toString());
        }
    }

    @HdfsCompatCase
    public void getAllStoragePolicies() throws IOException {
        Collection policies = this.fs().getAllStoragePolicies();
        Assertions.assertFalse((boolean)policies.isEmpty());
    }

    @HdfsCompatCase
    public void supportsSymlinks() {
        Assertions.assertTrue((boolean)this.fs().supportsSymlinks());
    }

    @HdfsCompatCase
    public void hasPathCapability() throws IOException {
        ArrayList<String> allCaps = new ArrayList<String>();
        allCaps.add("fs.capability.paths.acls");
        allCaps.add("fs.capability.paths.append");
        allCaps.add("fs.capability.paths.checksums");
        allCaps.add("fs.capability.paths.concat");
        allCaps.add("fs.capability.paths.list-corrupt-file-blocks");
        allCaps.add("fs.capability.paths.pathhandles");
        allCaps.add("fs.capability.paths.permissions");
        allCaps.add("fs.capability.paths.read-only-connector");
        allCaps.add("fs.capability.paths.snapshots");
        allCaps.add("fs.capability.paths.storagepolicy");
        allCaps.add("fs.capability.paths.symlinks");
        allCaps.add("fs.capability.paths.truncate");
        allCaps.add("fs.capability.paths.xattrs");
        Path base = this.getBasePath();
        for (String cap : allCaps) {
            if (!this.fs().hasPathCapability(base, cap)) continue;
            return;
        }
        throw new IOException("Cannot find any path capability");
    }
}

