/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.cases;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.compat.common.AbstractHdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseCleanup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseGroup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCasePrepare;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseSetUp;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseTearDown;
import org.apache.hadoop.fs.compat.common.HdfsCompatUtil;
import org.junit.jupiter.api.Assertions;

@HdfsCompatCaseGroup(name="Local")
public class HdfsCompatLocal
extends AbstractHdfsCompatCase {
    private static final int FILE_LEN = 128;
    private static final Random RANDOM = new Random();
    private LocalFileSystem localFs;
    private Path localBasePath;
    private Path localSrc;
    private Path localDst;
    private Path src;
    private Path dst;

    @HdfsCompatCaseSetUp
    public void setUp() throws IOException {
        this.localFs = FileSystem.getLocal((Configuration)this.fs().getConf());
        this.localBasePath = this.localFs.makeQualified(this.getLocalPath());
    }

    @HdfsCompatCaseTearDown
    public void tearDown() {
        HdfsCompatUtil.deleteQuietly((FileSystem)this.localFs, this.localBasePath, true);
    }

    @HdfsCompatCasePrepare
    public void prepare() throws IOException {
        String unique = System.currentTimeMillis() + "_" + RANDOM.nextLong() + "/";
        this.localSrc = new Path(this.localBasePath, unique + "src");
        this.localDst = new Path(this.localBasePath, unique + "dst");
        this.src = new Path(this.getBasePath(), unique + "src");
        this.dst = new Path(this.getBasePath(), unique + "dst");
        HdfsCompatUtil.createFile((FileSystem)this.localFs, this.localSrc, 128L);
        HdfsCompatUtil.createFile(this.fs(), this.src, 128L);
    }

    @HdfsCompatCaseCleanup
    public void cleanup() {
        HdfsCompatUtil.deleteQuietly(this.fs(), this.src.getParent(), true);
        HdfsCompatUtil.deleteQuietly((FileSystem)this.localFs, this.localSrc.getParent(), true);
    }

    @HdfsCompatCase
    public void copyFromLocalFile() throws IOException {
        this.fs().copyFromLocalFile(this.localSrc, this.dst);
        Assertions.assertTrue((boolean)this.localFs.exists(this.localSrc));
        Assertions.assertTrue((boolean)this.fs().exists(this.dst));
    }

    @HdfsCompatCase
    public void moveFromLocalFile() throws IOException {
        this.fs().moveFromLocalFile(this.localSrc, this.dst);
        Assertions.assertFalse((boolean)this.localFs.exists(this.localSrc));
        Assertions.assertTrue((boolean)this.fs().exists(this.dst));
    }

    @HdfsCompatCase
    public void copyToLocalFile() throws IOException {
        this.fs().copyToLocalFile(this.src, this.localDst);
        Assertions.assertTrue((boolean)this.fs().exists(this.src));
        Assertions.assertTrue((boolean)this.localFs.exists(this.localDst));
    }

    @HdfsCompatCase
    public void moveToLocalFile() throws IOException {
        this.fs().moveToLocalFile(this.src, this.localDst);
        Assertions.assertFalse((boolean)this.fs().exists(this.src));
        Assertions.assertTrue((boolean)this.localFs.exists(this.localDst));
    }

    @HdfsCompatCase
    public void startLocalOutput() throws IOException {
        Path local = this.fs().startLocalOutput(this.dst, this.localDst);
        HdfsCompatUtil.createFile((FileSystem)this.localFs, local, 16L);
        Assertions.assertTrue((boolean)this.localFs.exists(local));
    }

    @HdfsCompatCase
    public void completeLocalOutput() throws IOException {
        Path local = this.fs().startLocalOutput(this.dst, this.localDst);
        HdfsCompatUtil.createFile((FileSystem)this.localFs, local, 16L);
        this.fs().completeLocalOutput(this.dst, this.localDst);
        Assertions.assertTrue((boolean)this.fs().exists(this.dst));
    }
}

