/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.cases;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.compat.common.AbstractHdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseCleanup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseGroup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCasePrepare;
import org.apache.hadoop.fs.compat.common.HdfsCompatUtil;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.DataChecksum;
import org.junit.jupiter.api.Assertions;

@HdfsCompatCaseGroup(name="File")
public class HdfsCompatFile
extends AbstractHdfsCompatCase {
    private static final int FILE_LEN = 128;
    private static final long BLOCK_SIZE = 0x100000L;
    private static final short REPLICATION = 1;
    private static final Random RANDOM = new Random();
    private Path file = null;

    @HdfsCompatCasePrepare
    public void prepare() throws IOException {
        this.file = this.makePath("file");
        HdfsCompatUtil.createFile(this.fs(), this.file, true, 1024, 128L, 0x100000L, (short)1);
    }

    @HdfsCompatCaseCleanup
    public void cleanup() throws IOException {
        HdfsCompatUtil.deleteQuietly(this.fs(), this.file, true);
    }

    @HdfsCompatCase
    public void getFileStatus() throws IOException {
        FileStatus fileStatus = this.fs().getFileStatus(this.file);
        Assertions.assertNotNull((Object)fileStatus);
        Assertions.assertEquals((Object)this.file.getName(), (Object)fileStatus.getPath().getName());
    }

    @HdfsCompatCase
    public void exists() throws IOException {
        Assertions.assertTrue((boolean)this.fs().exists(this.file));
    }

    @HdfsCompatCase
    public void isFile() throws IOException {
        Assertions.assertTrue((boolean)this.fs().isFile(this.file));
    }

    @HdfsCompatCase
    public void getLength() throws IOException {
        Assertions.assertEquals((long)128L, (long)this.fs().getLength(this.file));
    }

    @HdfsCompatCase(brief="arbitrary blockSize")
    public void getBlockSize() throws IOException {
        Assertions.assertEquals((long)0x100000L, (long)this.fs().getBlockSize(this.file));
    }

    @HdfsCompatCase
    public void renameFile() throws IOException {
        Path dst = new Path(this.file.toString() + "_rename_dst");
        this.fs().rename(this.file, dst);
        Assertions.assertFalse((boolean)this.fs().exists(this.file));
        Assertions.assertTrue((boolean)this.fs().exists(dst));
    }

    @HdfsCompatCase
    public void deleteFile() throws IOException {
        this.fs().delete(this.file, true);
        Assertions.assertFalse((boolean)this.fs().exists(this.file));
    }

    @HdfsCompatCase
    public void deleteOnExit() throws IOException {
        FileSystem newFs = FileSystem.newInstance((URI)this.fs().getUri(), (Configuration)this.fs().getConf());
        newFs.deleteOnExit(this.file);
        newFs.close();
        Assertions.assertFalse((boolean)this.fs().exists(this.file));
    }

    @HdfsCompatCase
    public void cancelDeleteOnExit() throws IOException {
        FileSystem newFs = FileSystem.newInstance((URI)this.fs().getUri(), (Configuration)this.fs().getConf());
        newFs.deleteOnExit(this.file);
        newFs.cancelDeleteOnExit(this.file);
        newFs.close();
        Assertions.assertTrue((boolean)this.fs().exists(this.file));
    }

    @HdfsCompatCase
    public void truncate() throws IOException, InterruptedException {
        int newLen = RANDOM.nextInt(128);
        boolean finished = this.fs().truncate(this.file, (long)newLen);
        while (!finished) {
            Thread.sleep(1000L);
            finished = this.fs().truncate(this.file, (long)newLen);
        }
        FileStatus fileStatus = this.fs().getFileStatus(this.file);
        Assertions.assertEquals((long)newLen, (long)fileStatus.getLen());
    }

    @HdfsCompatCase
    public void setOwner() throws Exception {
        String owner = "test_" + RANDOM.nextInt(1024);
        String group = "test_" + RANDOM.nextInt(1024);
        String privileged = this.getPrivilegedUser();
        UserGroupInformation.createRemoteUser((String)privileged).doAs(() -> {
            FileSystem.newInstance((URI)this.fs().getUri(), (Configuration)this.fs().getConf()).setOwner(this.file, owner, group);
            return null;
        });
        FileStatus fileStatus = this.fs().getFileStatus(this.file);
        Assertions.assertEquals((Object)owner, (Object)fileStatus.getOwner());
        Assertions.assertEquals((Object)group, (Object)fileStatus.getGroup());
    }

    @HdfsCompatCase
    public void setTimes() throws IOException {
        long atime = System.currentTimeMillis();
        long mtime = atime - 1000L;
        this.fs().setTimes(this.file, mtime, atime);
        FileStatus fileStatus = this.fs().getFileStatus(this.file);
        Assertions.assertEquals((long)mtime, (long)fileStatus.getModificationTime());
        Assertions.assertEquals((long)atime, (long)fileStatus.getAccessTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HdfsCompatCase
    public void concat() throws IOException {
        Path dir = this.makePath("dir");
        try {
            Path src = new Path(dir, "src");
            Path dst = new Path(dir, "dst");
            HdfsCompatUtil.createFile(this.fs(), src, 64L);
            HdfsCompatUtil.createFile(this.fs(), dst, 16L);
            this.fs().concat(dst, new Path[]{src});
            FileStatus fileStatus = this.fs().getFileStatus(dst);
            Assertions.assertEquals((long)80L, (long)fileStatus.getLen());
        }
        finally {
            HdfsCompatUtil.deleteQuietly(this.fs(), dir, true);
        }
    }

    @HdfsCompatCase
    public void getFileChecksum() throws IOException {
        FileChecksum checksum = this.fs().getFileChecksum(this.file);
        Assertions.assertNotNull((Object)checksum);
        Assertions.assertNotNull((Object)checksum.getChecksumOpt());
        DataChecksum.Type type = checksum.getChecksumOpt().getChecksumType();
        Assertions.assertNotEquals((Object)DataChecksum.Type.NULL, (Object)type);
    }

    @HdfsCompatCase
    public void getFileBlockLocations() throws IOException {
        BlockLocation[] locations = this.fs().getFileBlockLocations(this.file, 0L, 128L);
        Assertions.assertTrue((locations.length >= 1 ? 1 : 0) != 0);
        BlockLocation location = locations[0];
        Assertions.assertTrue((location.getLength() > 0L ? 1 : 0) != 0);
    }

    @HdfsCompatCase
    public void getReplication() throws IOException {
        Assertions.assertEquals((short)1, (short)this.fs().getReplication(this.file));
    }

    @HdfsCompatCase(brief="arbitrary replication")
    public void setReplication() throws IOException {
        this.fs().setReplication(this.file, (short)2);
        Assertions.assertEquals((int)2, (int)this.fs().getReplication(this.file));
    }

    @HdfsCompatCase
    public void getPathHandle() throws IOException {
        FileStatus status = this.fs().getFileStatus(this.file);
        PathHandle handle = this.fs().getPathHandle(status, Options.HandleOpt.path());
        int maxReadLen = Math.min(128, 4096);
        byte[] data = new byte[maxReadLen];
        try (FSDataInputStream in = this.fs().open(handle, 1024);){
            in.readFully(data);
        }
    }

    @HdfsCompatCase
    public void open() throws IOException {
        FSDataInputStream in = null;
        try {
            in = this.fs().open(this.file);
            in.read();
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(in);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)in);
    }

    @HdfsCompatCase
    public void openFile() throws Exception {
        FSDataInputStream in = null;
        try {
            FutureDataInputStreamBuilder builder = this.fs().openFile(this.file);
            in = (FSDataInputStream)builder.build().get();
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(in);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)in);
    }

    @HdfsCompatCase
    public void access() throws IOException {
        this.fs().access(this.file, FsAction.READ);
    }

    @HdfsCompatCase
    public void setPermission() throws IOException {
        this.fs().setPermission(this.file, FsPermission.createImmutable((short)511));
        try {
            this.fs().access(this.file, FsAction.ALL);
            Assertions.fail((String)"Should not have write permission");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

