/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.cases;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.compat.common.AbstractHdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseCleanup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseGroup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCasePrepare;
import org.apache.hadoop.fs.compat.common.HdfsCompatUtil;
import org.junit.jupiter.api.Assertions;

@HdfsCompatCaseGroup(name="Directory")
public class HdfsCompatDirectory
extends AbstractHdfsCompatCase {
    private static final int FILE_LEN = 128;
    private Path dir = null;
    private Path file = null;

    @HdfsCompatCasePrepare
    public void prepare() throws IOException {
        this.dir = this.makePath("dir");
        this.file = new Path(this.dir, "file");
        HdfsCompatUtil.createFile(this.fs(), this.file, 128L);
    }

    @HdfsCompatCaseCleanup
    public void cleanup() throws IOException {
        HdfsCompatUtil.deleteQuietly(this.fs(), this.dir, true);
    }

    @HdfsCompatCase
    public void isDirectory() throws IOException {
        Assertions.assertTrue((boolean)this.fs().isDirectory(this.dir));
    }

    @HdfsCompatCase
    public void listStatus() throws IOException {
        FileStatus[] files = this.fs().listStatus(this.dir);
        Assertions.assertNotNull((Object)files);
        Assertions.assertEquals((int)1, (int)files.length);
        Assertions.assertEquals((Object)this.file.getName(), (Object)files[0].getPath().getName());
    }

    @HdfsCompatCase
    public void globStatus() throws IOException {
        FileStatus[] files = this.fs().globStatus(new Path(this.dir, "*ile"));
        Assertions.assertNotNull((Object)files);
        Assertions.assertEquals((int)1, (int)files.length);
        Assertions.assertEquals((Object)this.file.getName(), (Object)files[0].getPath().getName());
    }

    @HdfsCompatCase
    public void listLocatedStatus() throws IOException {
        RemoteIterator locatedFileStatuses = this.fs().listLocatedStatus(this.dir);
        Assertions.assertNotNull((Object)locatedFileStatuses);
        ArrayList<LocatedFileStatus> files = new ArrayList<LocatedFileStatus>();
        while (locatedFileStatuses.hasNext()) {
            files.add((LocatedFileStatus)locatedFileStatuses.next());
        }
        Assertions.assertEquals((int)1, (int)files.size());
        LocatedFileStatus fileStatus = (LocatedFileStatus)files.get(0);
        Assertions.assertEquals((Object)this.file.getName(), (Object)fileStatus.getPath().getName());
    }

    @HdfsCompatCase
    public void listStatusIterator() throws IOException {
        RemoteIterator fileStatuses = this.fs().listStatusIterator(this.dir);
        Assertions.assertNotNull((Object)fileStatuses);
        ArrayList<FileStatus> files = new ArrayList<FileStatus>();
        while (fileStatuses.hasNext()) {
            files.add((FileStatus)fileStatuses.next());
        }
        Assertions.assertEquals((int)1, (int)files.size());
        FileStatus fileStatus = (FileStatus)files.get(0);
        Assertions.assertEquals((Object)this.file.getName(), (Object)fileStatus.getPath().getName());
    }

    @HdfsCompatCase
    public void listFiles() throws IOException {
        RemoteIterator iter = this.fs().listFiles(this.dir, true);
        Assertions.assertNotNull((Object)iter);
        ArrayList<LocatedFileStatus> files = new ArrayList<LocatedFileStatus>();
        while (iter.hasNext()) {
            files.add((LocatedFileStatus)iter.next());
        }
        Assertions.assertEquals((int)1, (int)files.size());
    }

    @HdfsCompatCase
    public void listCorruptFileBlocks() throws IOException {
        RemoteIterator iter = this.fs().listCorruptFileBlocks(this.dir);
        Assertions.assertNotNull((Object)iter);
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @HdfsCompatCase
    public void getContentSummary() throws IOException {
        ContentSummary summary = this.fs().getContentSummary(this.dir);
        Assertions.assertEquals((long)1L, (long)summary.getFileCount());
        Assertions.assertEquals((long)1L, (long)summary.getDirectoryCount());
        Assertions.assertEquals((long)128L, (long)summary.getLength());
    }

    @HdfsCompatCase
    public void getUsed() throws IOException {
        long used = this.fs().getUsed(this.dir);
        Assertions.assertTrue((used >= 128L ? 1 : 0) != 0);
    }

    @HdfsCompatCase
    public void getQuotaUsage() throws IOException {
        QuotaUsage usage = this.fs().getQuotaUsage(this.dir);
        Assertions.assertEquals((long)2L, (long)usage.getFileAndDirectoryCount());
    }

    @HdfsCompatCase
    public void setQuota() throws IOException {
        this.fs().setQuota(this.dir, 0x100000L, 0x40000000L);
        QuotaUsage usage = this.fs().getQuotaUsage(this.dir);
        Assertions.assertEquals((long)0x100000L, (long)usage.getQuota());
    }

    @HdfsCompatCase
    public void setQuotaByStorageType() throws IOException {
        this.fs().setQuotaByStorageType(this.dir, StorageType.DISK, 0x100000L);
        QuotaUsage usage = this.fs().getQuotaUsage(this.dir);
        Assertions.assertEquals((long)0x100000L, (long)usage.getTypeQuota(StorageType.DISK));
    }
}

