/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.cases;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSDataOutputStreamBuilder;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.MultipartUploader;
import org.apache.hadoop.fs.MultipartUploaderBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UploadHandle;
import org.apache.hadoop.fs.compat.common.AbstractHdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseCleanup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseGroup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCasePrepare;
import org.apache.hadoop.fs.compat.common.HdfsCompatUtil;
import org.apache.hadoop.io.IOUtils;
import org.junit.jupiter.api.Assertions;

@HdfsCompatCaseGroup(name="Create")
public class HdfsCompatCreate
extends AbstractHdfsCompatCase {
    private Path path;

    @HdfsCompatCasePrepare
    public void prepare() {
        this.path = this.makePath("path");
    }

    @HdfsCompatCaseCleanup
    public void cleanup() {
        HdfsCompatUtil.deleteQuietly(this.fs(), this.path, true);
    }

    @HdfsCompatCase
    public void mkdirs() throws IOException {
        this.fs().mkdirs(this.path);
        Assertions.assertTrue((boolean)this.fs().exists(this.path));
    }

    @HdfsCompatCase
    public void create() throws IOException {
        FSDataOutputStream out = null;
        try {
            out = this.fs().create(this.path, true);
            Assertions.assertTrue((boolean)this.fs().exists(this.path));
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(out);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)out);
    }

    @HdfsCompatCase
    public void createNonRecursive() {
        Path file = new Path(this.path, "file-no-parent");
        try {
            this.fs().createNonRecursive(file, true, 1024, (short)1, 0x100000L, null);
            Assertions.fail((String)"Should fail since parent does not exist");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @HdfsCompatCase
    public void createNewFile() throws IOException {
        HdfsCompatUtil.createFile(this.fs(), this.path, 0L);
        Assertions.assertFalse((boolean)this.fs().createNewFile(this.path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HdfsCompatCase
    public void append() throws IOException {
        HdfsCompatUtil.createFile(this.fs(), this.path, 128L);
        FSDataOutputStream out = null;
        byte[] data = new byte[64];
        try {
            out = this.fs().append(this.path);
            out.write(data);
            out.close();
            out = null;
            FileStatus fileStatus = this.fs().getFileStatus(this.path);
            Assertions.assertEquals((long)192L, (long)fileStatus.getLen());
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(out);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HdfsCompatCase
    public void createFile() throws IOException {
        FSDataOutputStream out = null;
        this.fs().mkdirs(this.path);
        Path file = new Path(this.path, "file");
        try {
            FSDataOutputStreamBuilder builder = this.fs().createFile(file);
            out = builder.blockSize(0x200000L).build();
            out.write("Hello World!".getBytes(StandardCharsets.UTF_8));
            out.close();
            out = null;
            Assertions.assertTrue((boolean)this.fs().exists(file));
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(out);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HdfsCompatCase
    public void appendFile() throws IOException {
        HdfsCompatUtil.createFile(this.fs(), this.path, 128L);
        FSDataOutputStream out = null;
        byte[] data = new byte[64];
        try {
            FSDataOutputStreamBuilder builder = this.fs().appendFile(this.path);
            out = builder.build();
            out.write(data);
            out.close();
            out = null;
            FileStatus fileStatus = this.fs().getFileStatus(this.path);
            Assertions.assertEquals((long)192L, (long)fileStatus.getLen());
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(out);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HdfsCompatCase
    public void createMultipartUploader() throws Exception {
        block12: {
            MultipartUploader mpu;
            block13: {
                mpu = null;
                UploadHandle handle = null;
                try {
                    MultipartUploaderBuilder builder = this.fs().createMultipartUploader(this.path);
                    Path file = this.fs().makeQualified(new Path(this.path, "file"));
                    mpu = builder.blockSize(0x100000L).build();
                    CompletableFuture future = mpu.startUpload(file);
                    handle = (UploadHandle)future.get();
                    if (mpu == null) break block12;
                    if (handle == null) break block13;
                }
                catch (Throwable throwable) {
                    if (mpu != null) {
                        if (handle != null) {
                            try {
                                mpu.abort(handle, this.path);
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                        }
                        try {
                            mpu.abortUploadsUnderPath(this.path);
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    mpu.abort(handle, this.path);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                mpu.abortUploadsUnderPath(this.path);
            }
            catch (Throwable throwable) {}
        }
    }
}

