/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.cases;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.compat.common.AbstractHdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseGroup;
import org.apache.hadoop.fs.compat.common.HdfsCompatUtil;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;

@HdfsCompatCaseGroup(name="FileSystem")
public class HdfsCompatBasics
extends AbstractHdfsCompatCase {
    @HdfsCompatCase
    public void initialize() throws IOException {
        FileSystem another = FileSystem.newInstance((URI)this.fs().getUri(), (Configuration)this.fs().getConf());
        HdfsCompatUtil.checkImplementation(() -> another.initialize(URI.create("hdfs:///"), new Configuration()));
    }

    @HdfsCompatCase
    public void getScheme() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getScheme());
    }

    @HdfsCompatCase
    public void getUri() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getUri());
    }

    @HdfsCompatCase
    public void getCanonicalServiceName() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getCanonicalServiceName());
    }

    @HdfsCompatCase
    public void getName() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getName());
    }

    @HdfsCompatCase
    public void makeQualified() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().makeQualified(new Path("/")));
    }

    @HdfsCompatCase
    public void getChildFileSystems() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getChildFileSystems());
    }

    @HdfsCompatCase
    public void resolvePath() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().resolvePath(new Path("/")));
    }

    @HdfsCompatCase
    public void getHomeDirectory() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getHomeDirectory());
    }

    @HdfsCompatCase
    public void setWorkingDirectory() throws IOException {
        FileSystem another = FileSystem.newInstance((URI)this.fs().getUri(), (Configuration)this.fs().getConf());
        HdfsCompatUtil.checkImplementation(() -> another.setWorkingDirectory(this.makePath("/tmp")));
    }

    @HdfsCompatCase
    public void getWorkingDirectory() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getWorkingDirectory());
    }

    @HdfsCompatCase
    public void close() throws IOException {
        FileSystem another = FileSystem.newInstance((URI)this.fs().getUri(), (Configuration)this.fs().getConf());
        HdfsCompatUtil.checkImplementation(() -> ((FileSystem)another).close());
    }

    @HdfsCompatCase
    public void getDefaultBlockSize() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getDefaultBlockSize(this.getBasePath()));
    }

    @HdfsCompatCase
    public void getDefaultReplication() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getDefaultReplication(this.getBasePath()));
    }

    @HdfsCompatCase
    public void getStorageStatistics() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getStorageStatistics());
    }

    @HdfsCompatCase
    public void setVerifyChecksum() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().setVerifyChecksum(true));
    }

    @HdfsCompatCase
    public void setWriteChecksum() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().setWriteChecksum(true));
    }

    @HdfsCompatCase
    public void getDelegationToken() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getDelegationToken("hadoop"));
    }

    @HdfsCompatCase
    public void getAdditionalTokenIssuers() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getAdditionalTokenIssuers());
    }

    @HdfsCompatCase
    public void getServerDefaults() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getServerDefaults(new Path("/")));
    }

    @HdfsCompatCase
    public void msync() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().msync());
    }

    @HdfsCompatCase
    public void getStatus() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getStatus(new Path("/")));
    }

    @HdfsCompatCase
    public void getTrashRoot() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getTrashRoot(new Path("/user/hadoop/tmp")));
    }

    @HdfsCompatCase
    public void getTrashRoots() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getTrashRoots(true));
    }

    @HdfsCompatCase
    public void getAllStoragePolicies() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getAllStoragePolicies());
    }

    @HdfsCompatCase
    public void supportsSymlinks() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().supportsSymlinks());
    }

    @HdfsCompatCase
    public void hasPathCapability() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().hasPathCapability(this.getBasePath(), "fs.capability.paths.truncate"));
    }

    @HdfsCompatCase
    public void mkdirs() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().mkdirs(this.makePath("mkdir")));
    }

    @HdfsCompatCase
    public void getFileStatus() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getFileStatus(this.makePath("file")));
    }

    @HdfsCompatCase
    public void exists() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().exists(this.makePath("file")));
    }

    @HdfsCompatCase
    public void isDirectory() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().isDirectory(this.makePath("file")));
    }

    @HdfsCompatCase
    public void isFile() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().isFile(this.makePath("file")));
    }

    @HdfsCompatCase
    public void getLength() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getLength(this.makePath("file")));
    }

    @HdfsCompatCase
    public void getBlockSize() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getBlockSize(this.makePath("file")));
    }

    @HdfsCompatCase
    public void listStatus() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().listStatus(this.makePath("dir")));
    }

    @HdfsCompatCase
    public void globStatus() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().globStatus(this.makePath("dir")));
    }

    @HdfsCompatCase
    public void listLocatedStatus() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().listLocatedStatus(this.makePath("dir")));
    }

    @HdfsCompatCase
    public void listStatusIterator() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().listStatusIterator(this.makePath("dir")));
    }

    @HdfsCompatCase
    public void listFiles() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().listFiles(this.makePath("dir"), false));
    }

    @HdfsCompatCase
    public void rename() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().rename(this.makePath("src"), this.makePath("dst")));
    }

    @HdfsCompatCase
    public void delete() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().delete(this.makePath("file"), true));
    }

    @HdfsCompatCase
    public void deleteOnExit() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().deleteOnExit(this.makePath("file")));
    }

    @HdfsCompatCase
    public void cancelDeleteOnExit() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().cancelDeleteOnExit(this.makePath("file")));
    }

    @HdfsCompatCase
    public void truncate() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().truncate(this.makePath("file"), 1L));
    }

    @HdfsCompatCase
    public void setOwner() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().setOwner(this.makePath("file"), "test-user", "test-group"));
    }

    @HdfsCompatCase
    public void setTimes() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().setTimes(this.makePath("file"), 1696089600L, 1696089600L));
    }

    @HdfsCompatCase
    public void concat() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().concat(this.makePath("file"), new Path[]{this.makePath("file1"), this.makePath("file2")}));
    }

    @HdfsCompatCase
    public void getFileChecksum() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getFileChecksum(this.makePath("file")));
    }

    @HdfsCompatCase
    public void getFileBlockLocations() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getFileBlockLocations(new FileStatus(), 0L, 128L));
    }

    @HdfsCompatCase
    public void listCorruptFileBlocks() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().listCorruptFileBlocks(this.makePath("file")));
    }

    @HdfsCompatCase
    public void getReplication() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getReplication(this.makePath("file")));
    }

    @HdfsCompatCase
    public void setReplication() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().setReplication(this.makePath("file"), (short)2));
    }

    @HdfsCompatCase
    public void getPathHandle() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getPathHandle(new FileStatus(), new Options.HandleOpt[0]));
    }

    @HdfsCompatCase
    public void create() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().create(this.makePath("file"), true));
    }

    @HdfsCompatCase
    public void createNonRecursive() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().createNonRecursive(this.makePath("file"), true, 1024, (short)1, 0x100000L, null));
    }

    @HdfsCompatCase
    public void createNewFile() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().createNewFile(this.makePath("file")));
    }

    @HdfsCompatCase
    public void append() throws IOException {
        Path file = this.makePath("file");
        try {
            HdfsCompatUtil.createFile(this.fs(), file, 0L);
            HdfsCompatUtil.checkImplementation(() -> this.fs().append(file));
        }
        finally {
            HdfsCompatUtil.deleteQuietly(this.fs(), file, true);
        }
    }

    @HdfsCompatCase
    public void createFile() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().createFile(this.makePath("file")));
    }

    @HdfsCompatCase
    public void appendFile() throws IOException {
        Path file = this.makePath("file");
        try {
            HdfsCompatUtil.createFile(this.fs(), file, 0L);
            HdfsCompatUtil.checkImplementation(() -> this.fs().appendFile(file));
        }
        finally {
            HdfsCompatUtil.deleteQuietly(this.fs(), file, true);
        }
    }

    @HdfsCompatCase
    public void createMultipartUploader() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().createMultipartUploader(this.makePath("file")));
    }

    @HdfsCompatCase
    public void open() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().open(this.makePath("file")));
    }

    @HdfsCompatCase
    public void openFile() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().openFile(this.makePath("file")));
    }

    @HdfsCompatCase
    public void getContentSummary() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getContentSummary(this.makePath("dir")));
    }

    @HdfsCompatCase
    public void getUsed() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getUsed(this.makePath("dir")));
    }

    @HdfsCompatCase
    public void getQuotaUsage() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getQuotaUsage(this.makePath("dir")));
    }

    @HdfsCompatCase
    public void setQuota() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().setQuota(this.makePath("dir"), 1024L, 0x100000L));
    }

    @HdfsCompatCase
    public void setQuotaByStorageType() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().setQuotaByStorageType(this.makePath("dir"), StorageType.SSD, 0x100000L));
    }

    @HdfsCompatCase
    public void access() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().access(this.makePath("file"), FsAction.EXECUTE));
    }

    @HdfsCompatCase
    public void setPermission() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().setPermission(this.makePath("file"), FsPermission.getDefault()));
    }

    @HdfsCompatCase
    public void createSymlink() {
        FileSystem.enableSymlinks();
        HdfsCompatUtil.checkImplementation(() -> this.fs().createSymlink(this.makePath("file"), this.makePath("link"), true));
    }

    @HdfsCompatCase
    public void getFileLinkStatus() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getFileLinkStatus(this.makePath("file")));
    }

    @HdfsCompatCase
    public void getLinkTarget() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getLinkTarget(this.makePath("link")));
    }

    @HdfsCompatCase
    public void modifyAclEntries() {
        List entries = AclEntry.parseAclSpec((String)"user:foo:---", (boolean)true);
        HdfsCompatUtil.checkImplementation(() -> this.fs().modifyAclEntries(this.makePath("modifyAclEntries"), entries));
    }

    @HdfsCompatCase
    public void removeAclEntries() {
        List entries = AclEntry.parseAclSpec((String)"user:foo:---", (boolean)true);
        HdfsCompatUtil.checkImplementation(() -> this.fs().removeAclEntries(this.makePath("removeAclEntries"), entries));
    }

    @HdfsCompatCase
    public void removeDefaultAcl() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().removeDefaultAcl(this.makePath("removeDefaultAcl")));
    }

    @HdfsCompatCase
    public void removeAcl() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().removeAcl(this.makePath("removeAcl")));
    }

    @HdfsCompatCase
    public void setAcl() {
        List entries = AclEntry.parseAclSpec((String)"user:foo:---", (boolean)true);
        HdfsCompatUtil.checkImplementation(() -> this.fs().setAcl(this.makePath("setAcl"), entries));
    }

    @HdfsCompatCase
    public void getAclStatus() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getAclStatus(this.makePath("getAclStatus")));
    }

    @HdfsCompatCase
    public void setXAttr() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().setXAttr(this.makePath("file"), "test-xattr", "test-value".getBytes(StandardCharsets.UTF_8)));
    }

    @HdfsCompatCase
    public void getXAttr() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getXAttr(this.makePath("file"), "test-xattr"));
    }

    @HdfsCompatCase
    public void getXAttrs() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("test-xattr");
        HdfsCompatUtil.checkImplementation(() -> this.fs().getXAttrs(this.makePath("file"), names));
    }

    @HdfsCompatCase
    public void listXAttrs() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().listXAttrs(this.makePath("file")));
    }

    @HdfsCompatCase
    public void removeXAttr() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().removeXAttr(this.makePath("file"), "test-xattr"));
    }

    @HdfsCompatCase
    public void setStoragePolicy() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().setStoragePolicy(this.makePath("dir"), "COLD"));
    }

    @HdfsCompatCase
    public void unsetStoragePolicy() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().unsetStoragePolicy(this.makePath("dir")));
    }

    @HdfsCompatCase
    public void satisfyStoragePolicy() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().satisfyStoragePolicy(this.makePath("dir")));
    }

    @HdfsCompatCase
    public void getStoragePolicy() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().getStoragePolicy(this.makePath("dir")));
    }

    @HdfsCompatCase
    public void copyFromLocalFile() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().copyFromLocalFile(this.makePath("src"), this.makePath("dst")));
    }

    @HdfsCompatCase
    public void moveFromLocalFile() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().moveFromLocalFile(this.makePath("src"), this.makePath("dst")));
    }

    @HdfsCompatCase
    public void copyToLocalFile() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().copyToLocalFile(this.makePath("src"), this.makePath("dst")));
    }

    @HdfsCompatCase
    public void moveToLocalFile() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().moveToLocalFile(this.makePath("src"), this.makePath("dst")));
    }

    @HdfsCompatCase
    public void startLocalOutput() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().startLocalOutput(this.makePath("out"), this.makePath("tmp")));
    }

    @HdfsCompatCase
    public void completeLocalOutput() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().completeLocalOutput(this.makePath("out"), this.makePath("tmp")));
    }

    @HdfsCompatCase
    public void createSnapshot() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().createSnapshot(this.makePath("file"), "s_name"));
    }

    @HdfsCompatCase
    public void renameSnapshot() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().renameSnapshot(this.makePath("file"), "s_name", "n_name"));
    }

    @HdfsCompatCase
    public void deleteSnapshot() {
        HdfsCompatUtil.checkImplementation(() -> this.fs().deleteSnapshot(this.makePath("file"), "s_name"));
    }
}

