/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.cases;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.compat.common.AbstractHdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseCleanup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCaseGroup;
import org.apache.hadoop.fs.compat.common.HdfsCompatCasePrepare;
import org.apache.hadoop.fs.compat.common.HdfsCompatUtil;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.junit.jupiter.api.Assertions;

@HdfsCompatCaseGroup(name="ACL")
public class HdfsCompatAcl
extends AbstractHdfsCompatCase {
    private static final String INIT_FILE_ACL = "user::rwx,group::rwx,other::rwx,user:foo:rwx";
    private static final String INIT_DIR_ACL = "default:user::rwx,default:group::rwx,default:other::rwx";
    private Path dir;
    private Path file;

    @HdfsCompatCasePrepare
    public void prepare() throws IOException {
        this.dir = this.makePath("dir");
        this.file = new Path(this.dir, "file");
        HdfsCompatUtil.createFile(this.fs(), this.file, 0L);
        List entries = AclEntry.parseAclSpec((String)INIT_DIR_ACL, (boolean)true);
        this.fs().setAcl(this.dir, entries);
        entries = AclEntry.parseAclSpec((String)INIT_FILE_ACL, (boolean)true);
        this.fs().setAcl(this.file, entries);
    }

    @HdfsCompatCaseCleanup
    public void cleanup() throws IOException {
        HdfsCompatUtil.deleteQuietly(this.fs(), this.dir, true);
    }

    @HdfsCompatCase
    public void modifyAclEntries() throws IOException {
        List entries = AclEntry.parseAclSpec((String)"user:foo:---", (boolean)true);
        this.fs().modifyAclEntries(this.file, entries);
        List acls = this.fs().getAclStatus(this.file).getEntries();
        long count = 0L;
        for (AclEntry acl : acls) {
            if (!"foo".equals(acl.getName())) continue;
            ++count;
            Assertions.assertEquals((Object)FsAction.NONE, (Object)acl.getPermission());
        }
        Assertions.assertEquals((long)1L, (long)count);
    }

    @HdfsCompatCase
    public void removeAclEntries() throws IOException {
        List entries = AclEntry.parseAclSpec((String)"user:bar:---", (boolean)true);
        this.fs().modifyAclEntries(this.file, entries);
        entries = AclEntry.parseAclSpec((String)"user:foo:---", (boolean)true);
        this.fs().removeAclEntries(this.file, entries);
        List acls = this.fs().getAclStatus(this.file).getEntries();
        Assertions.assertTrue((boolean)acls.stream().noneMatch(e -> "foo".equals(e.getName())));
        Assertions.assertTrue((boolean)acls.stream().anyMatch(e -> "bar".equals(e.getName())));
    }

    @HdfsCompatCase
    public void removeDefaultAcl() throws IOException {
        this.fs().removeDefaultAcl(this.dir);
        List acls = this.fs().getAclStatus(this.dir).getEntries();
        Assertions.assertTrue((boolean)acls.stream().noneMatch(e -> e.getScope() == AclEntryScope.DEFAULT));
    }

    @HdfsCompatCase
    public void removeAcl() throws IOException {
        this.fs().removeAcl(this.file);
        List acls = this.fs().getAclStatus(this.file).getEntries();
        Assertions.assertTrue((boolean)acls.stream().noneMatch(e -> "foo".equals(e.getName())));
    }

    @HdfsCompatCase
    public void setAcl() throws IOException {
        List acls = this.fs().getAclStatus(this.file).getEntries();
        Assertions.assertTrue((boolean)acls.stream().anyMatch(e -> "foo".equals(e.getName())));
    }

    @HdfsCompatCase
    public void getAclStatus() throws IOException {
        AclStatus status = this.fs().getAclStatus(this.dir);
        Assertions.assertFalse((boolean)status.getOwner().isEmpty());
        Assertions.assertFalse((boolean)status.getGroup().isEmpty());
        List acls = status.getEntries();
        Assertions.assertTrue((boolean)acls.stream().anyMatch(e -> e.getScope() == AclEntryScope.DEFAULT));
        status = this.fs().getAclStatus(this.file);
        Assertions.assertFalse((boolean)status.getOwner().isEmpty());
        Assertions.assertFalse((boolean)status.getGroup().isEmpty());
        acls = status.getEntries();
        Assertions.assertTrue((boolean)acls.stream().anyMatch(e -> e.getScope() == AclEntryScope.ACCESS));
    }
}

