/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.compat.common.HdfsCompatCommand;
import org.apache.hadoop.fs.compat.common.HdfsCompatIllegalArgumentException;
import org.apache.hadoop.fs.compat.common.HdfsCompatReport;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsCompatTool
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsCompatTool.class);
    private static final String DESCRIPTION = "hadoop jar hadoop-compat-bench-{version}.jar -uri <uri> [-suite <suiteName>] [-output <outputFile>]:\n\tTrigger a compatibility assessment for a specific FileSystem implementation.\n\tA compatibility report is generated after the command finished, showing how many interfaces/functions are implemented and compatible with HDFS definition.\n\t-uri is required to determine the target FileSystem.\n\t-suite is optional for limiting the assessment to a subset. For example, 'shell' means only shell commands.\n\t-output is optional for a detailed report, which should be a local file path if provided.";
    private final PrintStream out;
    private final PrintStream err;
    private String uri = null;
    private String suite = null;
    private String output = null;

    public HdfsCompatTool(Configuration conf) {
        this(conf, System.out, System.err);
    }

    public HdfsCompatTool(Configuration conf, PrintStream out, PrintStream err) {
        super(conf);
        this.out = out;
        this.err = err;
    }

    public int run(final String[] args) throws Exception {
        try {
            return (Integer)UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() {
                    return HdfsCompatTool.this.runImpl(args);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private int runImpl(String[] args) {
        if (this.isHelp(args)) {
            this.printUsage();
            return 0;
        }
        try {
            this.parseArgs(args);
            return this.doRun();
        }
        catch (Exception e) {
            this.printError(e.getMessage());
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRun() throws Exception {
        HdfsCompatCommand cmd = new HdfsCompatCommand(this.uri, this.suite, this.getConf());
        cmd.initialize();
        HdfsCompatReport report = cmd.apply();
        FileOutputStream outputFile = null;
        try {
            if (this.output != null) {
                outputFile = new FileOutputStream(new File(this.output));
            }
        }
        catch (Exception e) {
            LOG.error("Create output file failed", (Throwable)e);
            outputFile = null;
        }
        try {
            this.printReport(report, outputFile);
        }
        finally {
            IOUtils.closeStream(outputFile);
        }
        return 0;
    }

    private boolean isHelp(String[] args) {
        if (args == null || args.length == 0) {
            return true;
        }
        return args.length == 1 && (args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("--help"));
    }

    private void parseArgs(String[] args) {
        CommandFormat cf = new CommandFormat(0, Integer.MAX_VALUE, new String[0]);
        cf.addOptionWithValue("uri");
        cf.addOptionWithValue("suite");
        cf.addOptionWithValue("output");
        cf.parse(args, 0);
        this.uri = cf.getOptValue("uri");
        this.suite = cf.getOptValue("suite");
        this.output = cf.getOptValue("output");
        if (this.isEmpty(this.uri)) {
            throw new HdfsCompatIllegalArgumentException("-uri is not specified.");
        }
        if (this.isEmpty(this.suite)) {
            this.suite = "ALL";
        }
    }

    private boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    private void printError(String message) {
        this.err.println(message);
    }

    private void printOut(String message) {
        this.out.println(message);
    }

    public void printReport(HdfsCompatReport report, OutputStream detailStream) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Hadoop Compatibility Report for ");
        buffer.append(report.getSuite().getSuiteName());
        buffer.append(":\n");
        long passed = report.getPassedCase().size();
        long failed = report.getFailedCase().size();
        String percent = failed == 0L ? "100" : String.format("%.2f", (double)passed / (double)(passed + failed) * 100.0);
        buffer.append("\t");
        buffer.append(percent);
        buffer.append("%, PASSED ");
        buffer.append(passed);
        buffer.append(" OVER ");
        buffer.append(passed + failed);
        buffer.append("\n");
        buffer.append("\tURI: ");
        buffer.append(report.getUri());
        if (report.getSuite() != null) {
            buffer.append(" (suite: ");
            buffer.append(report.getSuite().getClass().getName());
            buffer.append(")");
        }
        buffer.append("\n");
        buffer.append("\tHadoop Version as Baseline: ");
        buffer.append(VersionInfo.getVersion());
        String shortMessage = buffer.toString();
        this.printOut(shortMessage);
        if (detailStream != null) {
            detailStream.write(shortMessage.getBytes(StandardCharsets.UTF_8));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(detailStream, StandardCharsets.UTF_8));
            writer.newLine();
            writer.write("PASSED CASES:");
            writer.newLine();
            Collection<String> cases = report.getPassedCase();
            for (String c : cases) {
                writer.write(9);
                writer.write(c);
                writer.newLine();
                writer.flush();
            }
            writer.write("FAILED CASES:");
            writer.newLine();
            cases = report.getFailedCase();
            for (String c : cases) {
                writer.write(9);
                writer.write(c);
                writer.newLine();
                writer.flush();
            }
            writer.flush();
        }
    }

    private void printUsage() {
        this.printError(DESCRIPTION);
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new HdfsCompatTool(new Configuration()), (String[])args);
        System.exit(res);
    }
}

