/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.hdfs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.compat.common.HdfsCompatEnvironment;
import org.apache.hadoop.fs.compat.common.HdfsCompatShellScope;
import org.apache.hadoop.fs.compat.common.HdfsCompatSuite;

public class HdfsCompatTestShellScope
extends HdfsCompatShellScope {
    private final HdfsCompatEnvironment env;

    public HdfsCompatTestShellScope(HdfsCompatEnvironment env, HdfsCompatSuite suite) {
        super(env, suite);
        this.env = env;
    }

    protected String[] getEnv(File localDir, File scriptDir, File confDir) throws IOException {
        this.replace(scriptDir);
        File binDir = new File(scriptDir, "bin");
        this.copyToBin(binDir);
        confDir = new File(scriptDir, "hadoop-conf-ut");
        this.writeConf(confDir);
        File logConfFile = new File(confDir, "log4j.properties");
        this.copyResource("/hadoop-compat-bench-log4j.properties", logConfFile);
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        String classpath = confDir.getAbsolutePath() + ":" + System.getProperty("java.class.path");
        Object pathenv = System.getenv("PATH");
        pathenv = pathenv == null || ((String)pathenv).isEmpty() ? binDir.getAbsolutePath() : binDir.getAbsolutePath() + ":" + (String)pathenv;
        ArrayList<CallSite> confEnv = new ArrayList<CallSite>();
        Collections.addAll(confEnv, super.getEnv(localDir, scriptDir, confDir));
        confEnv.add((CallSite)((Object)("HADOOP_COMPAT_JAVA_BIN=" + javaBin)));
        confEnv.add((CallSite)((Object)("HADOOP_COMPAT_JAVA_CLASSPATH=" + classpath)));
        confEnv.add((CallSite)((Object)("HADOOP_CONF_DIR=" + confDir.getAbsolutePath())));
        confEnv.add((CallSite)((Object)("PATH=" + (String)pathenv)));
        return confEnv.toArray(new String[0]);
    }

    @VisibleForTesting
    protected void replace(File scriptDir) throws IOException {
    }

    private void copyToBin(File binDir) throws IOException {
        Files.createDirectories(binDir.toPath(), new FileAttribute[0]);
        File hadoop = new File(binDir, "hadoop");
        File hdfs = new File(binDir, "hdfs");
        this.copyResource("/hadoop-compat-bench-test-shell-hadoop.sh", hadoop);
        this.copyResource("/hadoop-compat-bench-test-shell-hdfs.sh", hdfs);
        if (!(hadoop.setReadable(true, false) && hadoop.setWritable(true, false) && hadoop.setExecutable(true, false))) {
            throw new IOException("No permission to hadoop shell.");
        }
        if (!(hdfs.setReadable(true, false) && hdfs.setWritable(true, false) && hdfs.setExecutable(true, false))) {
            throw new IOException("No permission to hdfs shell.");
        }
    }

    private void writeConf(File confDir) throws IOException {
        Files.createDirectories(confDir.toPath(), new FileAttribute[0]);
        if (!(confDir.setReadable(true, false) && confDir.setWritable(true, false) && confDir.setExecutable(true, false))) {
            throw new IOException("No permission to conf dir.");
        }
        File confFile = new File(confDir, "core-site.xml");
        try (FileOutputStream out = new FileOutputStream(confFile);){
            this.env.getFileSystem().getConf().writeXml((OutputStream)out);
        }
        if (!(confFile.setReadable(true, false) && confFile.setWritable(true, false) && confFile.setExecutable(true, false))) {
            throw new IOException("No permission to conf file.");
        }
    }
}

