/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.hdfs;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.compat.common.HdfsCompatCommand;
import org.apache.hadoop.fs.compat.common.HdfsCompatEnvironment;
import org.apache.hadoop.fs.compat.common.HdfsCompatShellScope;
import org.apache.hadoop.fs.compat.common.HdfsCompatSuite;
import org.apache.hadoop.fs.compat.hdfs.HdfsCompatTestShellScope;

public class HdfsCompatTestCommand
extends HdfsCompatCommand {
    public HdfsCompatTestCommand(String uri, String suiteName, Configuration conf) {
        super(uri, suiteName, conf);
    }

    public void initialize() throws IOException, ReflectiveOperationException {
        super.initialize();
        Field shellField = HdfsCompatCommand.class.getDeclaredField("shell");
        shellField.setAccessible(true);
        HdfsCompatShellScope shell = (HdfsCompatShellScope)shellField.get((Object)this);
        if (shell != null) {
            Field envField = shell.getClass().getDeclaredField("env");
            envField.setAccessible(true);
            HdfsCompatEnvironment env = (HdfsCompatEnvironment)envField.get(shell);
            Field suiteField = HdfsCompatCommand.class.getDeclaredField("suite");
            suiteField.setAccessible(true);
            HdfsCompatSuite suite = (HdfsCompatSuite)suiteField.get((Object)this);
            shellField.set((Object)this, this.getShellScope(env, suite));
        }
    }

    protected HdfsCompatShellScope getShellScope(HdfsCompatEnvironment env, HdfsCompatSuite suite) {
        return new HdfsCompatTestShellScope(env, suite);
    }
}

