/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.hdfs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsCompatMiniCluster {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsCompatMiniCluster.class);
    private MiniDFSCluster cluster = null;

    public synchronized void start() throws IOException {
        FileSystem.enableSymlinks();
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.delegation.token.always-use", "true");
        conf.set("hadoop.security.key.provider.path", "kms://http@localhost:9600/kms/foo");
        conf.set("dfs.storage.policy.satisfier.mode", "external");
        conf.set("dfs.namenode.acls.enabled", "true");
        conf.set("fs.hdfs.compatibility.privileged.user", UserGroupInformation.getCurrentUser().getShortUserName());
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        this.cluster.waitClusterUp();
    }

    public synchronized void shutdown() {
        if (this.cluster != null) {
            this.cluster.shutdown(true);
            this.cluster = null;
        }
    }

    public synchronized Configuration getConf() throws IOException {
        if (this.cluster == null) {
            throw new IOException("Cluster not running");
        }
        return this.cluster.getFileSystem().getConf();
    }

    public synchronized URI getUri() throws IOException {
        if (this.cluster == null) {
            throw new IOException("Cluster not running");
        }
        return this.cluster.getFileSystem().getUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InterruptedException {
        long duration = 300000L;
        if (args != null && args.length > 0) {
            duration = Long.parseLong(args[0]);
        }
        HdfsCompatMiniCluster cluster = new HdfsCompatMiniCluster();
        try {
            cluster.start();
            Configuration conf = cluster.getConf();
            String confDir = System.getenv("HADOOP_CONF_DIR");
            File confFile = new File(confDir, "core-site.xml");
            try (FileOutputStream out = new FileOutputStream(confFile);){
                conf.writeXml((OutputStream)out);
            }
            long endTime = System.currentTimeMillis() + duration;
            long sleepTime = HdfsCompatMiniCluster.getSleepTime(endTime);
            while (sleepTime > 0L) {
                LOG.warn("Service running ...");
                Thread.sleep(sleepTime);
                sleepTime = HdfsCompatMiniCluster.getSleepTime(endTime);
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    private static long getSleepTime(long endTime) {
        long maxTime = endTime - System.currentTimeMillis();
        return maxTime < 5000L ? maxTime : 5000L;
    }
}

