/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.common;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.compat.HdfsCompatTool;
import org.apache.hadoop.fs.compat.common.HdfsCompatEnvironment;
import org.apache.hadoop.fs.compat.common.HdfsCompatReport;
import org.apache.hadoop.fs.compat.common.HdfsCompatShellScope;
import org.apache.hadoop.fs.compat.common.HdfsCompatSuite;
import org.apache.hadoop.fs.compat.hdfs.HdfsCompatMiniCluster;
import org.apache.hadoop.fs.compat.hdfs.HdfsCompatTestCommand;
import org.apache.hadoop.fs.compat.hdfs.HdfsCompatTestShellScope;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHdfsCompatShellCommand {
    private HdfsCompatMiniCluster cluster;

    @BeforeEach
    public void runCluster() throws IOException {
        this.cluster = new HdfsCompatMiniCluster();
        this.cluster.start();
    }

    @AfterEach
    public void shutdownCluster() {
        this.cluster.shutdown();
        this.cluster = null;
    }

    @Test
    public void testDfsCompatibility() throws Exception {
        String uri = this.cluster.getUri() + "/tmp";
        Configuration conf = this.cluster.getConf();
        TestCommand cmd = new TestCommand(uri, conf);
        cmd.initialize();
        HdfsCompatReport report = cmd.apply();
        Assertions.assertEquals((int)3, (int)report.getPassedCase().size());
        Assertions.assertEquals((int)0, (int)report.getFailedCase().size());
        this.show(conf, report);
    }

    @Test
    public void testSkipCompatibility() throws Exception {
        String uri = this.cluster.getUri() + "/tmp";
        Configuration conf = this.cluster.getConf();
        TestSkipCommand cmd = new TestSkipCommand(uri, conf);
        cmd.initialize();
        HdfsCompatReport report = cmd.apply();
        Assertions.assertEquals((int)2, (int)report.getPassedCase().size());
        Assertions.assertEquals((int)0, (int)report.getFailedCase().size());
        this.show(conf, report);
    }

    private void show(Configuration conf, HdfsCompatReport report) throws IOException {
        new HdfsCompatTool(conf).printReport(report, (OutputStream)System.out);
    }

    private static final class TestCommand
    extends HdfsCompatTestCommand {
        private TestCommand(String uri, Configuration conf) {
            super(uri, "shell", conf);
        }

        @Override
        protected HdfsCompatShellScope getShellScope(HdfsCompatEnvironment env, HdfsCompatSuite suite) {
            return new TestShellScope(env, suite);
        }
    }

    private static final class TestSkipCommand
    extends HdfsCompatTestCommand {
        private TestSkipCommand(String uri, Configuration conf) {
            super(uri, "shell", conf);
        }

        @Override
        protected HdfsCompatShellScope getShellScope(HdfsCompatEnvironment env, HdfsCompatSuite suite) {
            return new TestShellScopeForSkip(env, suite);
        }
    }

    private static final class TestShellScopeForSkip
    extends HdfsCompatTestShellScope {
        private TestShellScopeForSkip(HdfsCompatEnvironment env, HdfsCompatSuite suite) {
            super(env, suite);
        }

        @Override
        protected void replace(File scriptDir) throws IOException {
            File casesDir = new File(scriptDir, "cases");
            FileUtils.deleteDirectory((File)casesDir);
            Files.createDirectories(casesDir.toPath(), new FileAttribute[0]);
            this.copyResource("/test-case-skip.t", new File(casesDir, "test-case-skip.t"));
        }
    }

    private static final class TestShellScope
    extends HdfsCompatTestShellScope {
        private TestShellScope(HdfsCompatEnvironment env, HdfsCompatSuite suite) {
            super(env, suite);
        }

        @Override
        protected void replace(File scriptDir) throws IOException {
            File casesDir = new File(scriptDir, "cases");
            FileUtils.deleteDirectory((File)casesDir);
            Files.createDirectories(casesDir.toPath(), new FileAttribute[0]);
            this.copyResource("/test-case-simple.t", new File(casesDir, "test-case-simple.t"));
        }
    }
}

