/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.common;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.compat.HdfsCompatTool;
import org.apache.hadoop.fs.compat.cases.HdfsCompatAclTestCases;
import org.apache.hadoop.fs.compat.cases.HdfsCompatMkdirTestCases;
import org.apache.hadoop.fs.compat.common.AbstractHdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatApiScope;
import org.apache.hadoop.fs.compat.common.HdfsCompatCommand;
import org.apache.hadoop.fs.compat.common.HdfsCompatEnvironment;
import org.apache.hadoop.fs.compat.common.HdfsCompatReport;
import org.apache.hadoop.fs.compat.common.HdfsCompatSuite;
import org.apache.hadoop.fs.compat.hdfs.HdfsCompatMiniCluster;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHdfsCompatFsCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDfsCompatibility() throws Exception {
        String suite = "ALL";
        HdfsCompatMiniCluster cluster = null;
        try {
            cluster = new HdfsCompatMiniCluster();
            cluster.start();
            String uri = cluster.getUri() + "/tmp";
            Configuration conf = cluster.getConf();
            TestCommand cmd = new TestCommand(uri, "ALL", conf);
            cmd.initialize();
            HdfsCompatReport report = cmd.apply();
            Assertions.assertEquals((int)7, (int)report.getPassedCase().size());
            Assertions.assertEquals((int)0, (int)report.getFailedCase().size());
            this.show(conf, report);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testLocalFsCompatibility() throws Exception {
        String uri = "file:///tmp/";
        String suite = "ALL";
        Configuration conf = new Configuration();
        TestCommand cmd = new TestCommand("file:///tmp/", "ALL", conf);
        cmd.initialize();
        HdfsCompatReport report = cmd.apply();
        Assertions.assertEquals((int)1, (int)report.getPassedCase().size());
        Assertions.assertEquals((int)6, (int)report.getFailedCase().size());
        this.show(conf, report);
        this.cleanup(cmd, conf);
    }

    @Test
    public void testFsCompatibilityWithSuite() throws Exception {
        String uri = "file:///tmp/";
        String suite = "acl";
        Configuration conf = new Configuration();
        TestCommand cmd = new TestCommand("file:///tmp/", "acl", conf);
        cmd.initialize();
        HdfsCompatReport report = cmd.apply();
        Assertions.assertEquals((int)0, (int)report.getPassedCase().size());
        Assertions.assertEquals((int)6, (int)report.getFailedCase().size());
        this.show(conf, report);
        this.cleanup(cmd, conf);
    }

    private void show(Configuration conf, HdfsCompatReport report) throws IOException {
        new HdfsCompatTool(conf).printReport(report, (OutputStream)System.out);
    }

    private void cleanup(HdfsCompatCommand cmd, Configuration conf) throws Exception {
        Path basePath = ((TestCommand)cmd).getBasePath();
        FileSystem fs = basePath.getFileSystem(conf);
        fs.delete(basePath, true);
    }

    private static final class TestCommand
    extends HdfsCompatCommand {
        private TestCommand(String uri, String suiteName, Configuration conf) {
            super(uri, suiteName, conf);
        }

        protected Map<String, HdfsCompatSuite> getDefaultSuites() {
            HashMap<String, HdfsCompatSuite> defaultSuites = new HashMap<String, HdfsCompatSuite>();
            defaultSuites.put("all", new AllTestSuite());
            defaultSuites.put("mkdir", new MkdirTestSuite());
            defaultSuites.put("acl", new AclTestSuite());
            return defaultSuites;
        }

        private Path getBasePath() throws ReflectiveOperationException {
            Field apiField = HdfsCompatCommand.class.getDeclaredField("api");
            apiField.setAccessible(true);
            HdfsCompatApiScope api = (HdfsCompatApiScope)apiField.get((Object)this);
            Field envField = api.getClass().getDeclaredField("env");
            envField.setAccessible(true);
            HdfsCompatEnvironment env = (HdfsCompatEnvironment)envField.get(api);
            return env.getBase();
        }
    }

    private static class AclTestSuite
    implements HdfsCompatSuite {
        private AclTestSuite() {
        }

        public String getSuiteName() {
            return "ACL";
        }

        public Class<? extends AbstractHdfsCompatCase>[] getApiCases() {
            return new Class[]{HdfsCompatAclTestCases.class};
        }

        public String[] getShellCases() {
            return new String[0];
        }
    }

    private static class MkdirTestSuite
    implements HdfsCompatSuite {
        private MkdirTestSuite() {
        }

        public String getSuiteName() {
            return "Mkdir";
        }

        public Class<? extends AbstractHdfsCompatCase>[] getApiCases() {
            return new Class[]{HdfsCompatMkdirTestCases.class};
        }

        public String[] getShellCases() {
            return new String[0];
        }
    }

    private static class AllTestSuite
    implements HdfsCompatSuite {
        private AllTestSuite() {
        }

        public String getSuiteName() {
            return "All (Test)";
        }

        public Class<? extends AbstractHdfsCompatCase>[] getApiCases() {
            return new Class[]{HdfsCompatMkdirTestCases.class, HdfsCompatAclTestCases.class};
        }

        public String[] getShellCases() {
            return new String[0];
        }
    }
}

