/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.common;

import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.compat.HdfsCompatTool;
import org.apache.hadoop.fs.compat.common.HdfsCompatReport;
import org.apache.hadoop.fs.compat.hdfs.HdfsCompatMiniCluster;
import org.apache.hadoop.fs.compat.hdfs.HdfsCompatTestCommand;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHdfsCompatDefaultSuites {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuiteAll() throws Exception {
        HdfsCompatMiniCluster cluster = new HdfsCompatMiniCluster();
        try {
            cluster.start();
            String uri = cluster.getUri() + "/tmp";
            Configuration conf = cluster.getConf();
            HdfsCompatTestCommand cmd = new HdfsCompatTestCommand(uri, "ALL", conf);
            cmd.initialize();
            HdfsCompatReport report = cmd.apply();
            Assertions.assertEquals((int)0, (int)report.getFailedCase().size());
            new HdfsCompatTool(conf).printReport(report, (OutputStream)System.out);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuiteTpcds() throws Exception {
        HdfsCompatMiniCluster cluster = new HdfsCompatMiniCluster();
        try {
            cluster.start();
            String uri = cluster.getUri() + "/tmp";
            Configuration conf = cluster.getConf();
            HdfsCompatTestCommand cmd = new HdfsCompatTestCommand(uri, "TPCDS", conf);
            cmd.initialize();
            HdfsCompatReport report = cmd.apply();
            Assertions.assertEquals((int)0, (int)report.getFailedCase().size());
            new HdfsCompatTool(conf).printReport(report, (OutputStream)System.out);
        }
        finally {
            cluster.shutdown();
        }
    }
}

