/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.dynamic.BindingUtils;
import org.apache.hadoop.util.dynamic.DynConstructors;
import org.apache.hadoop.util.dynamic.DynMethods;

@InterfaceAudience.Private
public class SignalUtil {
    static final Class<?> JDK_SIGNAL_CLAZZ = BindingUtils.loadClassSafely("sun.misc.Signal");
    static final Class<?> JDK_SIGNAL_HANDLER_CLAZZ = BindingUtils.loadClassSafely("sun.misc.SignalHandler");
    static final DynConstructors.Ctor<?> JDK_SIGNAL_CTOR = new DynConstructors.Builder().impl(JDK_SIGNAL_CLAZZ, String.class).build();
    static final DynMethods.StaticMethod JDK_SIGNAL_HANDLE_STATIC_METHOD = new DynMethods.Builder("handle").impl(JDK_SIGNAL_CLAZZ, JDK_SIGNAL_CLAZZ, JDK_SIGNAL_HANDLER_CLAZZ).buildStatic();
    static final DynMethods.StaticMethod JDK_SIGNAL_RAISE_STATIC_METHOD = new DynMethods.Builder("raise").impl(JDK_SIGNAL_CLAZZ, JDK_SIGNAL_CLAZZ).buildStatic();
    static final DynMethods.UnboundMethod JDK_SIGNAL_HANDLER_HANDLE_UNBOUND_METHOD = new DynMethods.Builder("handle").impl(JDK_SIGNAL_HANDLER_CLAZZ, JDK_SIGNAL_CLAZZ).build();

    public static Handler handle(Signal sig, Handler handler) {
        Object preHandle = JDK_SIGNAL_HANDLE_STATIC_METHOD.invoke(sig.delegate, new JdkSignalHandlerImpl(handler).delegate);
        return new JdkSignalHandlerImpl(preHandle);
    }

    public static void raise(Signal sig) throws IllegalArgumentException {
        JDK_SIGNAL_RAISE_STATIC_METHOD.invoke(sig.delegate);
    }

    static class JdkSignalHandlerImpl
    implements Handler {
        private final Object delegate;
        private final DynMethods.BoundMethod jdkSignalHandlerHandleMethod;

        JdkSignalHandlerImpl(Handler handler) {
            this.delegate = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{JDK_SIGNAL_HANDLER_CLAZZ}, (proxyObj, method, args) -> {
                if ("handle".equals(method.getName()) && args.length == 1 && JDK_SIGNAL_CLAZZ.isInstance(args[0])) {
                    handler.handle(new Signal(args[0]));
                    return null;
                }
                Method delegateMethod = handler.getClass().getMethod(method.getName(), method.getParameterTypes());
                return delegateMethod.invoke((Object)handler, args);
            });
            this.jdkSignalHandlerHandleMethod = JDK_SIGNAL_HANDLER_HANDLE_UNBOUND_METHOD.bind(this.delegate);
        }

        JdkSignalHandlerImpl(Object delegate) {
            Preconditions.checkArgument(JDK_SIGNAL_HANDLER_CLAZZ.isInstance(delegate), String.format("Expected class is '%s', but actual class is '%s'", JDK_SIGNAL_HANDLER_CLAZZ.getName(), delegate.getClass().getName()));
            this.delegate = delegate;
            this.jdkSignalHandlerHandleMethod = JDK_SIGNAL_HANDLER_HANDLE_UNBOUND_METHOD.bind(delegate);
        }

        @Override
        public void handle(Signal sig) {
            this.jdkSignalHandlerHandleMethod.invoke(sig.delegate);
        }
    }

    @InterfaceAudience.Private
    public static interface Handler {
        public void handle(Signal var1);
    }

    @InterfaceAudience.Private
    public static class Signal {
        private static final DynMethods.UnboundMethod GET_NUMBER_UNBOUND_METHOD = new DynMethods.Builder("getNumber").impl(JDK_SIGNAL_CLAZZ, new Class[0]).build();
        private static final DynMethods.UnboundMethod GET_NAME_UNBOUND_METHOD = new DynMethods.Builder("getName").impl(JDK_SIGNAL_CLAZZ, new Class[0]).build();
        private final Object delegate;
        private final DynMethods.BoundMethod getNumberMethod;
        private final DynMethods.BoundMethod getNameMethod;

        public Signal(String name) {
            Preconditions.checkNotNull(name);
            this.delegate = JDK_SIGNAL_CTOR.newInstance(name);
            this.getNumberMethod = GET_NUMBER_UNBOUND_METHOD.bind(this.delegate);
            this.getNameMethod = GET_NAME_UNBOUND_METHOD.bind(this.delegate);
        }

        public Signal(Object delegate) {
            Preconditions.checkArgument(JDK_SIGNAL_CLAZZ.isInstance(delegate), String.format("Expected class is '%s', but actual class is '%s'", JDK_SIGNAL_CLAZZ.getName(), delegate.getClass().getName()));
            this.delegate = delegate;
            this.getNumberMethod = GET_NUMBER_UNBOUND_METHOD.bind(delegate);
            this.getNameMethod = GET_NAME_UNBOUND_METHOD.bind(delegate);
        }

        public int getNumber() {
            return (Integer)this.getNumberMethod.invoke(new Object[0]);
        }

        public String getName() {
            return (String)this.getNameMethod.invoke(new Object[0]);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Signal) {
                return this.delegate.equals(((Signal)obj).delegate);
            }
            return false;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

