/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.CrcUtil;
import org.apache.hadoop.util.DataChecksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Common", "HDFS", "MapReduce", "Yarn"})
@InterfaceStability.Unstable
public class CrcComposer {
    private static final int CRC_SIZE_BYTES = 4;
    private static final Logger LOG = LoggerFactory.getLogger(CrcComposer.class);
    private final int crcPolynomial;
    private final int precomputedMonomialForHint;
    private final long bytesPerCrcHint;
    private final long stripeLength;
    private int curCompositeCrc = 0;
    private long curPositionInStripe = 0L;
    private final ByteArrayOutputStream digestOut = new ByteArrayOutputStream();

    public static CrcComposer newCrcComposer(DataChecksum.Type type, long bytesPerCrcHint) {
        return CrcComposer.newStripedCrcComposer(type, bytesPerCrcHint, Long.MAX_VALUE);
    }

    public static CrcComposer newStripedCrcComposer(DataChecksum.Type type, long bytesPerCrcHint, long stripeLength) {
        int polynomial = DataChecksum.getCrcPolynomialForType(type);
        return new CrcComposer(polynomial, CrcUtil.getMonomial(bytesPerCrcHint, polynomial), bytesPerCrcHint, stripeLength);
    }

    CrcComposer(int crcPolynomial, int precomputedMonomialForHint, long bytesPerCrcHint, long stripeLength) {
        LOG.debug("crcPolynomial=0x{}, precomputedMonomialForHint=0x{}, bytesPerCrcHint={}, stripeLength={}", new Object[]{Integer.toString(crcPolynomial, 16), Integer.toString(precomputedMonomialForHint, 16), bytesPerCrcHint, stripeLength});
        this.crcPolynomial = crcPolynomial;
        this.precomputedMonomialForHint = precomputedMonomialForHint;
        this.bytesPerCrcHint = bytesPerCrcHint;
        this.stripeLength = stripeLength;
    }

    public void update(byte[] crcBuffer, int offset, int length, long bytesPerCrc) {
        if (length % 4 != 0) {
            throw new IllegalArgumentException(String.format("Trying to update CRC from byte array with length '%d' at offset '%d' which is not a multiple of %d!", length, offset, 4));
        }
        int limit = offset + length;
        while (offset < limit) {
            int crcB = CrcUtil.readInt(crcBuffer, offset);
            this.update(crcB, bytesPerCrc);
            offset += 4;
        }
    }

    public void update(DataInputStream checksumIn, long numChecksumsToRead, long bytesPerCrc) throws IOException {
        for (long i = 0L; i < numChecksumsToRead; ++i) {
            int crcB = checksumIn.readInt();
            this.update(crcB, bytesPerCrc);
        }
    }

    public void update(int crcB, long bytesPerCrc) {
        this.curCompositeCrc = this.curCompositeCrc == 0 ? crcB : (bytesPerCrc == this.bytesPerCrcHint ? CrcUtil.composeWithMonomial(this.curCompositeCrc, crcB, this.precomputedMonomialForHint, this.crcPolynomial) : CrcUtil.compose(this.curCompositeCrc, crcB, bytesPerCrc, this.crcPolynomial));
        this.curPositionInStripe += bytesPerCrc;
        if (this.curPositionInStripe > this.stripeLength) {
            throw new IllegalStateException(String.format("Current position in stripe '%d' after advancing by bytesPerCrc '%d' exceeds stripeLength '%d' without stripe alignment.", this.curPositionInStripe, bytesPerCrc, this.stripeLength));
        }
        if (this.curPositionInStripe == this.stripeLength) {
            this.digestOut.write(CrcUtil.intToBytes(this.curCompositeCrc), 0, 4);
            this.curCompositeCrc = 0;
            this.curPositionInStripe = 0L;
        }
    }

    public byte[] digest() {
        if (this.curPositionInStripe > 0L) {
            this.digestOut.write(CrcUtil.intToBytes(this.curCompositeCrc), 0, 4);
            this.curCompositeCrc = 0;
            this.curPositionInStripe = 0L;
        }
        byte[] digestValue = this.digestOut.toByteArray();
        this.digestOut.reset();
        return digestValue;
    }
}

