/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.SecretKey;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.util.Metrics2Util;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.functional.InvocationRaisingIOE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class AbstractDelegationTokenSecretManager<TokenIdent extends AbstractDelegationTokenIdentifier>
extends SecretManager<TokenIdent> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDelegationTokenSecretManager.class);
    private static final DelegationTokenSecretManagerMetrics METRICS = DelegationTokenSecretManagerMetrics.create();
    protected Map<TokenIdent, DelegationTokenInformation> currentTokens;
    protected final Map<String, Long> tokenOwnerStats = new ConcurrentHashMap<String, Long>();
    protected int delegationTokenSequenceNumber = 0;
    protected final Map<Integer, DelegationKey> allKeys = new ConcurrentHashMap<Integer, DelegationKey>();
    protected int currentId = 0;
    private DelegationKey currentKey;
    private final long keyUpdateInterval;
    private final long tokenMaxLifetime;
    private final long tokenRemoverScanInterval;
    private final long tokenRenewInterval;
    protected boolean storeTokenTrackingId;
    private Thread tokenRemoverThread;
    protected volatile boolean running;
    protected Object noInterruptsLock = new Object();
    private final ReentrantReadWriteLock apiLock = new ReentrantReadWriteLock(true);

    private String formatTokenId(TokenIdent id) {
        try {
            return "(" + id + ")";
        }
        catch (Exception e) {
            LOG.warn("Exception in formatTokenId", (Throwable)e);
            return "( SequenceNumber=" + ((AbstractDelegationTokenIdentifier)id).getSequenceNumber() + " )";
        }
    }

    public AbstractDelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval) {
        this.keyUpdateInterval = delegationKeyUpdateInterval;
        this.tokenMaxLifetime = delegationTokenMaxLifetime;
        this.tokenRenewInterval = delegationTokenRenewInterval;
        this.tokenRemoverScanInterval = delegationTokenRemoverScanInterval;
        this.storeTokenTrackingId = false;
        this.currentTokens = new ConcurrentHashMap<TokenIdent, DelegationTokenInformation>();
    }

    public void startThreads() throws IOException {
        Preconditions.checkState(!this.running);
        this.updateCurrentKey();
        this.apiLock.writeLock().lock();
        try {
            this.running = true;
            this.tokenRemoverThread = new Daemon(new ExpiredTokenRemover());
            this.tokenRemoverThread.start();
        }
        finally {
            this.apiLock.writeLock().unlock();
        }
    }

    public void reset() {
        this.apiLock.writeLock().lock();
        try {
            this.setCurrentKeyId(0);
            this.allKeys.clear();
            this.setDelegationTokenSeqNum(0);
            this.currentTokens.clear();
        }
        finally {
            this.apiLock.writeLock().unlock();
        }
    }

    public long getCurrentTokensSize() {
        return this.currentTokens.size();
    }

    protected long getTokenRenewInterval() {
        return this.tokenRenewInterval;
    }

    public void addKey(DelegationKey key) throws IOException {
        if (this.running) {
            throw new IOException("Can't add delegation key to a running SecretManager.");
        }
        this.apiLock.writeLock().lock();
        try {
            if (key.getKeyId() > this.getCurrentKeyId()) {
                this.setCurrentKeyId(key.getKeyId());
            }
            this.allKeys.put(key.getKeyId(), key);
        }
        finally {
            this.apiLock.writeLock().unlock();
        }
    }

    public DelegationKey[] getAllKeys() {
        this.apiLock.readLock().lock();
        try {
            DelegationKey[] delegationKeyArray = this.allKeys.values().toArray(new DelegationKey[0]);
            return delegationKeyArray;
        }
        finally {
            this.apiLock.readLock().unlock();
        }
    }

    protected void logUpdateMasterKey(DelegationKey key) throws IOException {
    }

    protected void logExpireToken(TokenIdent ident) throws IOException {
    }

    protected void storeNewMasterKey(DelegationKey key) throws IOException {
    }

    protected void removeStoredMasterKey(DelegationKey key) {
    }

    protected void storeNewToken(TokenIdent ident, long renewDate) throws IOException {
    }

    protected void removeStoredToken(TokenIdent ident) throws IOException {
    }

    protected void updateStoredToken(TokenIdent ident, long renewDate) throws IOException {
    }

    protected int getCurrentKeyId() {
        this.apiLock.readLock().lock();
        try {
            int n = this.currentId;
            return n;
        }
        finally {
            this.apiLock.readLock().unlock();
        }
    }

    protected int incrementCurrentKeyId() {
        this.apiLock.writeLock().lock();
        try {
            int n = ++this.currentId;
            return n;
        }
        finally {
            this.apiLock.writeLock().unlock();
        }
    }

    protected void setCurrentKeyId(int keyId) {
        this.apiLock.writeLock().lock();
        try {
            this.currentId = keyId;
        }
        finally {
            this.apiLock.writeLock().unlock();
        }
    }

    protected int getDelegationTokenSeqNum() {
        this.apiLock.readLock().lock();
        try {
            int n = this.delegationTokenSequenceNumber;
            return n;
        }
        finally {
            this.apiLock.readLock().unlock();
        }
    }

    protected int incrementDelegationTokenSeqNum() {
        this.apiLock.writeLock().lock();
        try {
            int n = ++this.delegationTokenSequenceNumber;
            return n;
        }
        finally {
            this.apiLock.writeLock().unlock();
        }
    }

    protected void setDelegationTokenSeqNum(int seqNum) {
        this.apiLock.writeLock().lock();
        try {
            this.delegationTokenSequenceNumber = seqNum;
        }
        finally {
            this.apiLock.writeLock().unlock();
        }
    }

    protected DelegationKey getDelegationKey(int keyId) {
        return this.allKeys.get(keyId);
    }

    protected void storeDelegationKey(DelegationKey key) throws IOException {
        this.allKeys.put(key.getKeyId(), key);
        this.storeNewMasterKey(key);
    }

    protected void updateDelegationKey(DelegationKey key) throws IOException {
        this.allKeys.put(key.getKeyId(), key);
    }

    protected DelegationTokenInformation getTokenInfo(TokenIdent ident) {
        return this.currentTokens.get(ident);
    }

    protected void storeToken(TokenIdent ident, DelegationTokenInformation tokenInfo) throws IOException {
        this.currentTokens.put(ident, tokenInfo);
        this.addTokenForOwnerStats(ident);
        this.storeNewToken(ident, tokenInfo.getRenewDate());
    }

    protected void updateToken(TokenIdent ident, DelegationTokenInformation tokenInfo) throws IOException {
        this.currentTokens.put(ident, tokenInfo);
        this.updateStoredToken(ident, tokenInfo.getRenewDate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPersistedDelegationToken(TokenIdent identifier, long renewDate) throws IOException {
        block8: {
            if (this.running) {
                throw new IOException("Can't add persisted delegation token to a running SecretManager.");
            }
            this.apiLock.writeLock().lock();
            try {
                int keyId = ((AbstractDelegationTokenIdentifier)identifier).getMasterKeyId();
                DelegationKey dKey = this.allKeys.get(keyId);
                byte[] password = null;
                if (dKey == null) {
                    LOG.warn("No KEY found for persisted identifier, expiring stored token " + this.formatTokenId(identifier));
                    renewDate = 0L;
                } else {
                    password = AbstractDelegationTokenSecretManager.createPassword(((TokenIdentifier)identifier).getBytes(), dKey.getKey());
                }
                if (((AbstractDelegationTokenIdentifier)identifier).getSequenceNumber() > this.getDelegationTokenSeqNum()) {
                    this.setDelegationTokenSeqNum(((AbstractDelegationTokenIdentifier)identifier).getSequenceNumber());
                }
                if (this.getTokenInfo(identifier) == null) {
                    this.currentTokens.put(identifier, new DelegationTokenInformation(renewDate, password, this.getTrackingIdIfEnabled(identifier)));
                    this.addTokenForOwnerStats(identifier);
                    break block8;
                }
                throw new IOException("Same delegation token being added twice: " + this.formatTokenId(identifier));
            }
            finally {
                this.apiLock.writeLock().unlock();
            }
        }
    }

    private void updateCurrentKey() throws IOException {
        LOG.info("Updating the current master key for generating delegation tokens");
        int newCurrentId = this.incrementCurrentKeyId();
        DelegationKey newKey = new DelegationKey(newCurrentId, System.currentTimeMillis() + this.keyUpdateInterval + this.tokenMaxLifetime, this.generateSecret());
        this.logUpdateMasterKey(newKey);
        this.apiLock.writeLock().lock();
        try {
            this.currentKey = newKey;
            this.storeDelegationKey(this.currentKey);
        }
        finally {
            this.apiLock.writeLock().unlock();
        }
    }

    protected void rollMasterKey() throws IOException {
        this.apiLock.writeLock().lock();
        try {
            this.removeExpiredKeys();
            this.currentKey.setExpiryDate(Time.now() + this.tokenMaxLifetime);
            this.updateDelegationKey(this.currentKey);
        }
        finally {
            this.apiLock.writeLock().unlock();
        }
        this.updateCurrentKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExpiredKeys() {
        this.apiLock.writeLock().lock();
        try {
            long now = Time.now();
            Iterator<Map.Entry<Integer, DelegationKey>> it = this.allKeys.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, DelegationKey> e = it.next();
                if (e.getValue().getExpiryDate() >= now) continue;
                it.remove();
                if (e.getValue().equals(this.currentKey)) continue;
                this.removeStoredMasterKey(e.getValue());
            }
        }
        finally {
            this.apiLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] createPassword(TokenIdent identifier) {
        this.apiLock.writeLock().lock();
        try {
            long now = Time.now();
            int sequenceNum = this.incrementDelegationTokenSeqNum();
            ((AbstractDelegationTokenIdentifier)identifier).setIssueDate(now);
            ((AbstractDelegationTokenIdentifier)identifier).setMaxDate(now + this.tokenMaxLifetime);
            ((AbstractDelegationTokenIdentifier)identifier).setMasterKeyId(this.currentKey.getKeyId());
            ((AbstractDelegationTokenIdentifier)identifier).setSequenceNumber(sequenceNum);
            LOG.info("Creating password for identifier: " + this.formatTokenId(identifier) + ", currentKey: " + this.currentKey.getKeyId());
            byte[] password = AbstractDelegationTokenSecretManager.createPassword(((TokenIdentifier)identifier).getBytes(), this.currentKey.getKey());
            DelegationTokenInformation tokenInfo = new DelegationTokenInformation(now + this.tokenRenewInterval, password, this.getTrackingIdIfEnabled(identifier));
            try {
                METRICS.trackStoreToken(() -> this.storeToken(identifier, tokenInfo));
            }
            catch (IOException ioe) {
                LOG.error("Could not store token " + this.formatTokenId(identifier) + "!!", (Throwable)ioe);
            }
            byte[] byArray = password;
            return byArray;
        }
        finally {
            this.apiLock.writeLock().unlock();
        }
    }

    protected DelegationTokenInformation checkToken(TokenIdent identifier) throws SecretManager.InvalidToken {
        DelegationTokenInformation info = this.getTokenInfo(identifier);
        if (info == null) {
            String err = "Token for real user: " + ((AbstractDelegationTokenIdentifier)identifier).getRealUser() + ", can't be found in cache";
            LOG.warn("{}, Token={}", (Object)err, (Object)this.formatTokenId(identifier));
            throw new SecretManager.InvalidToken(err);
        }
        long now = Time.now();
        if (info.getRenewDate() < now) {
            String err = "Token " + ((AbstractDelegationTokenIdentifier)identifier).getRealUser() + " has expired, current time: " + Time.formatTime(now) + " expected renewal time: " + Time.formatTime(info.getRenewDate());
            LOG.info("{}, Token={}", (Object)err, (Object)this.formatTokenId(identifier));
            throw new SecretManager.InvalidToken(err);
        }
        return info;
    }

    @Override
    public byte[] retrievePassword(TokenIdent identifier) throws SecretManager.InvalidToken {
        this.apiLock.readLock().lock();
        try {
            byte[] byArray = this.checkToken(identifier).getPassword();
            return byArray;
        }
        finally {
            this.apiLock.readLock().unlock();
        }
    }

    protected String getTrackingIdIfEnabled(TokenIdent ident) {
        if (this.storeTokenTrackingId) {
            return ((TokenIdentifier)ident).getTrackingId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTokenTrackingId(TokenIdent identifier) {
        this.apiLock.readLock().lock();
        try {
            DelegationTokenInformation info = this.getTokenInfo(identifier);
            if (info == null) {
                String string = null;
                return string;
            }
            String string = info.getTrackingId();
            return string;
        }
        finally {
            this.apiLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyToken(TokenIdent identifier, byte[] password) throws SecretManager.InvalidToken {
        this.apiLock.readLock().lock();
        try {
            byte[] storedPassword = this.retrievePassword(identifier);
            if (!MessageDigest.isEqual(password, storedPassword)) {
                throw new SecretManager.InvalidToken("token " + this.formatTokenId(identifier) + " is invalid, password doesn't match");
            }
        }
        finally {
            this.apiLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long renewToken(Token<TokenIdent> token, String renewer) throws SecretManager.InvalidToken, IOException {
        this.apiLock.writeLock().lock();
        try {
            ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
            DataInputStream in = new DataInputStream(buf);
            AbstractDelegationTokenIdentifier id = (AbstractDelegationTokenIdentifier)this.createIdentifier();
            id.readFields(in);
            LOG.info("Token renewal for identifier: " + this.formatTokenId(id) + "; total currentTokens " + this.currentTokens.size());
            long now = Time.now();
            if (id.getMaxDate() < now) {
                throw new SecretManager.InvalidToken(renewer + " tried to renew an expired token " + this.formatTokenId(id) + " max expiration date: " + Time.formatTime(id.getMaxDate()) + " currentTime: " + Time.formatTime(now));
            }
            if (id.getRenewer() == null || id.getRenewer().toString().isEmpty()) {
                throw new AccessControlException(renewer + " tried to renew a token " + this.formatTokenId(id) + " without a renewer");
            }
            if (!id.getRenewer().toString().equals(renewer)) {
                throw new AccessControlException(renewer + " tries to renew a token " + this.formatTokenId(id) + " with non-matching renewer " + id.getRenewer());
            }
            DelegationKey key = this.getDelegationKey(id.getMasterKeyId());
            if (key == null) {
                throw new SecretManager.InvalidToken("Unable to find master key for keyId=" + id.getMasterKeyId() + " from cache. Failed to renew an unexpired token " + this.formatTokenId(id) + " with sequenceNumber=" + id.getSequenceNumber());
            }
            byte[] password = AbstractDelegationTokenSecretManager.createPassword(token.getIdentifier(), key.getKey());
            if (!MessageDigest.isEqual(password, token.getPassword())) {
                throw new AccessControlException(renewer + " is trying to renew a token " + this.formatTokenId(id) + " with wrong password");
            }
            long renewTime = Math.min(id.getMaxDate(), now + this.tokenRenewInterval);
            String trackingId = this.getTrackingIdIfEnabled(id);
            DelegationTokenInformation info = new DelegationTokenInformation(renewTime, password, trackingId);
            if (this.getTokenInfo(id) == null) {
                throw new SecretManager.InvalidToken("Renewal request for unknown token " + this.formatTokenId(id));
            }
            METRICS.trackUpdateToken(() -> this.updateToken(id, info));
            long l = renewTime;
            return l;
        }
        finally {
            this.apiLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenIdent cancelToken(Token<TokenIdent> token, String canceller) throws IOException {
        this.apiLock.writeLock().lock();
        try {
            ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
            DataInputStream in = new DataInputStream(buf);
            AbstractDelegationTokenIdentifier id = (AbstractDelegationTokenIdentifier)this.createIdentifier();
            id.readFields(in);
            LOG.info("Token cancellation requested for identifier: " + this.formatTokenId(id));
            if (id.getUser() == null) {
                throw new SecretManager.InvalidToken("Token with no owner " + this.formatTokenId(id));
            }
            String owner = id.getUser().getUserName();
            Text renewer = id.getRenewer();
            HadoopKerberosName cancelerKrbName = new HadoopKerberosName(canceller);
            String cancelerShortName = cancelerKrbName.getShortName();
            if (!(canceller.equals(owner) || renewer != null && !renewer.toString().isEmpty() && cancelerShortName.equals(renewer.toString()))) {
                throw new AccessControlException(canceller + " is not authorized to cancel the token " + this.formatTokenId(id));
            }
            DelegationTokenInformation info = this.currentTokens.remove(id);
            if (info == null) {
                throw new SecretManager.InvalidToken("Token not found " + this.formatTokenId(id));
            }
            METRICS.trackRemoveToken(() -> {
                this.removeTokenForOwnerStats(id);
                this.removeStoredToken(id);
            });
            AbstractDelegationTokenIdentifier abstractDelegationTokenIdentifier = id;
            return (TokenIdent)abstractDelegationTokenIdentifier;
        }
        finally {
            this.apiLock.writeLock().unlock();
        }
    }

    public static SecretKey createSecretKey(byte[] key) {
        return SecretManager.createSecretKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExpiredToken() throws IOException {
        long now = Time.now();
        HashSet<TokenIdent> expiredTokens = new HashSet<TokenIdent>();
        this.apiLock.writeLock().lock();
        try {
            Iterator<Map.Entry<TokenIdent, DelegationTokenInformation>> i = this.getCandidateTokensForCleanup().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<TokenIdent, DelegationTokenInformation> entry = i.next();
                long renewDate = entry.getValue().getRenewDate();
                if (renewDate >= now) continue;
                expiredTokens.add(entry.getKey());
                this.removeTokenForOwnerStats((AbstractDelegationTokenIdentifier)entry.getKey());
                i.remove();
            }
        }
        finally {
            this.apiLock.writeLock().unlock();
        }
        this.logExpireTokens(expiredTokens);
    }

    protected Map<TokenIdent, DelegationTokenInformation> getCandidateTokensForCleanup() {
        return this.currentTokens;
    }

    protected void logExpireTokens(Collection<TokenIdent> expiredTokens) throws IOException {
        for (AbstractDelegationTokenIdentifier ident : expiredTokens) {
            this.logExpireToken(ident);
            LOG.info("Removing expired token " + this.formatTokenId(ident));
            this.removeExpiredStoredToken(ident);
        }
    }

    protected void removeExpiredStoredToken(TokenIdent ident) throws IOException {
        this.removeStoredToken(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThreads() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping expired delegation token remover thread");
        }
        this.running = false;
        if (this.tokenRemoverThread != null) {
            Object object = this.noInterruptsLock;
            synchronized (object) {
                this.tokenRemoverThread.interrupt();
            }
            try {
                this.tokenRemoverThread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unable to join on token removal thread", e);
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public TokenIdent decodeTokenIdentifier(Token<TokenIdent> token) throws IOException {
        return (TokenIdent)((AbstractDelegationTokenIdentifier)token.decodeIdentifier());
    }

    public List<Metrics2Util.NameValuePair> getTopTokenRealOwners(int n) {
        if ((n = Math.min(n, this.tokenOwnerStats.size())) == 0) {
            return new ArrayList<Metrics2Util.NameValuePair>();
        }
        Metrics2Util.TopN topN = new Metrics2Util.TopN(n);
        for (Map.Entry<String, Long> entry : this.tokenOwnerStats.entrySet()) {
            topN.offer(new Metrics2Util.NameValuePair(entry.getKey(), entry.getValue()));
        }
        ArrayList<Metrics2Util.NameValuePair> list = new ArrayList<Metrics2Util.NameValuePair>();
        while (!topN.isEmpty()) {
            list.add((Metrics2Util.NameValuePair)topN.poll());
        }
        Collections.reverse(list);
        return list;
    }

    private String getTokenRealOwner(TokenIdent id) {
        String realUser = ((AbstractDelegationTokenIdentifier)id).getRealUser() != null && !((AbstractDelegationTokenIdentifier)id).getRealUser().toString().isEmpty() ? ((AbstractDelegationTokenIdentifier)id).getRealUser().toString() : ((AbstractDelegationTokenIdentifier)id).getUser().getUserName();
        return realUser;
    }

    protected void addTokenForOwnerStats(TokenIdent id) {
        String realOwner = this.getTokenRealOwner(id);
        this.tokenOwnerStats.put(realOwner, this.tokenOwnerStats.getOrDefault(realOwner, 0L) + 1L);
    }

    private void removeTokenForOwnerStats(TokenIdent id) {
        String realOwner = this.getTokenRealOwner(id);
        if (this.tokenOwnerStats.containsKey(realOwner)) {
            if (this.tokenOwnerStats.get(realOwner) <= 1L) {
                this.tokenOwnerStats.remove(realOwner);
            } else {
                this.tokenOwnerStats.put(realOwner, this.tokenOwnerStats.get(realOwner) - 1L);
            }
        }
    }

    protected void syncTokenOwnerStats() {
        this.tokenOwnerStats.clear();
        for (AbstractDelegationTokenIdentifier id : this.currentTokens.keySet()) {
            this.addTokenForOwnerStats(id);
        }
    }

    protected DelegationTokenSecretManagerMetrics getMetrics() {
        return METRICS;
    }

    @Metrics(about="Delegation token secret manager metrics", context="token")
    static class DelegationTokenSecretManagerMetrics
    implements DurationTrackerFactory {
        private static final Logger LOG = LoggerFactory.getLogger(DelegationTokenSecretManagerMetrics.class);
        static final String STORE_TOKEN_STAT = "storeToken";
        static final String UPDATE_TOKEN_STAT = "updateToken";
        static final String REMOVE_TOKEN_STAT = "removeToken";
        static final String TOKEN_FAILURE_STAT = "tokenFailure";
        private final MetricsRegistry registry;
        private final IOStatisticsStore ioStatistics = IOStatisticsBinding.iostatisticsStore().withDurationTracking("storeToken", "updateToken", "removeToken").withCounters("tokenFailure").build();
        @Metric(value={"Rate of storage of delegation tokens and latency (milliseconds)"})
        private MutableRate storeToken;
        @Metric(value={"Rate of update of delegation tokens and latency (milliseconds)"})
        private MutableRate updateToken;
        @Metric(value={"Rate of removal of delegation tokens and latency (milliseconds)"})
        private MutableRate removeToken;
        @Metric(value={"Counter of delegation tokens operation failures"})
        private MutableCounterLong tokenFailure;

        static DelegationTokenSecretManagerMetrics create() {
            return DefaultMetricsSystem.instance().register(new DelegationTokenSecretManagerMetrics());
        }

        DelegationTokenSecretManagerMetrics() {
            this.registry = new MetricsRegistry("DelegationTokenSecretManagerMetrics");
            LOG.debug("Initialized {}", (Object)this.registry);
        }

        public void trackStoreToken(InvocationRaisingIOE invocation) throws IOException {
            this.trackInvocation(invocation, STORE_TOKEN_STAT, this.storeToken);
        }

        public void trackUpdateToken(InvocationRaisingIOE invocation) throws IOException {
            this.trackInvocation(invocation, UPDATE_TOKEN_STAT, this.updateToken);
        }

        public void trackRemoveToken(InvocationRaisingIOE invocation) throws IOException {
            this.trackInvocation(invocation, REMOVE_TOKEN_STAT, this.removeToken);
        }

        public void trackInvocation(InvocationRaisingIOE invocation, String statistic, MutableRate metric) throws IOException {
            try {
                long start = Time.monotonicNow();
                IOStatisticsBinding.trackDurationOfInvocation(this, statistic, invocation);
                metric.add(Time.monotonicNow() - start);
            }
            catch (Exception ex) {
                this.tokenFailure.incr();
                throw ex;
            }
        }

        @Override
        public DurationTracker trackDuration(String key, long count) {
            return this.ioStatistics.trackDuration(key, count);
        }

        protected MutableRate getStoreToken() {
            return this.storeToken;
        }

        protected MutableRate getUpdateToken() {
            return this.updateToken;
        }

        protected MutableRate getRemoveToken() {
            return this.removeToken;
        }

        protected MutableCounterLong getTokenFailure() {
            return this.tokenFailure;
        }

        protected IOStatisticsStore getIoStatistics() {
            return this.ioStatistics;
        }
    }

    private class ExpiredTokenRemover
    extends Thread {
        private long lastMasterKeyUpdate;
        private long lastTokenCacheCleanup;

        private ExpiredTokenRemover() {
        }

        @Override
        public void run() {
            LOG.info("Starting expired delegation token remover thread, tokenRemoverScanInterval=" + AbstractDelegationTokenSecretManager.this.tokenRemoverScanInterval / 60000L + " min(s)");
            block6: while (true) {
                try {
                    while (AbstractDelegationTokenSecretManager.this.running) {
                        long now = Time.now();
                        if (this.lastMasterKeyUpdate + AbstractDelegationTokenSecretManager.this.keyUpdateInterval < now) {
                            try {
                                AbstractDelegationTokenSecretManager.this.rollMasterKey();
                                this.lastMasterKeyUpdate = now;
                            }
                            catch (IOException e) {
                                LOG.error("Master key updating failed: ", (Throwable)e);
                            }
                        }
                        if (this.lastTokenCacheCleanup + AbstractDelegationTokenSecretManager.this.tokenRemoverScanInterval < now) {
                            AbstractDelegationTokenSecretManager.this.removeExpiredToken();
                            this.lastTokenCacheCleanup = now;
                        }
                        try {
                            Thread.sleep(Math.min(5000L, AbstractDelegationTokenSecretManager.this.keyUpdateInterval));
                            continue block6;
                        }
                        catch (InterruptedException ie) {
                            LOG.error("ExpiredTokenRemover received " + ie);
                        }
                    }
                    break;
                }
                catch (Throwable t) {
                    LOG.error("ExpiredTokenRemover thread received unexpected exception", t);
                    Runtime.getRuntime().exit(-1);
                    break;
                }
            }
        }
    }

    @InterfaceStability.Evolving
    public static class DelegationTokenInformation
    implements Writable {
        long renewDate;
        byte[] password;
        String trackingId;

        public DelegationTokenInformation() {
            this(0L, null);
        }

        public DelegationTokenInformation(long renewDate, byte[] password) {
            this(renewDate, password, null);
        }

        public DelegationTokenInformation(long renewDate, byte[] password, String trackingId) {
            this.renewDate = renewDate;
            this.password = password;
            this.trackingId = trackingId;
        }

        public long getRenewDate() {
            return this.renewDate;
        }

        byte[] getPassword() {
            return this.password;
        }

        public String getTrackingId() {
            return this.trackingId;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            WritableUtils.writeVLong(out, this.renewDate);
            if (this.password == null) {
                WritableUtils.writeVInt(out, -1);
            } else {
                WritableUtils.writeVInt(out, this.password.length);
                out.write(this.password);
            }
            WritableUtils.writeString(out, this.trackingId);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.renewDate = WritableUtils.readVLong(in);
            int len = WritableUtils.readVInt(in);
            if (len > -1) {
                this.password = new byte[len];
                in.readFully(this.password);
            }
            this.trackingId = WritableUtils.readString(in);
        }
    }
}

