/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CustomizedCallbackHandler {
    public static final Logger LOG = LoggerFactory.getLogger(CustomizedCallbackHandler.class);

    public static CustomizedCallbackHandler delegate(Object delegated) {
        Method method;
        String methodName = "handleCallbacks";
        Class<?> clazz = delegated.getClass();
        try {
            method = clazz.getMethod("handleCallbacks", List.class, String.class, char[].class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Failed to get method handleCallbacks from " + clazz, e);
        }
        return (callbacks, name, password) -> {
            try {
                method.invoke(delegated, callbacks, name, password);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IOException("Failed to invoke " + method, e);
            }
        };
    }

    public static CustomizedCallbackHandler get(String key, Configuration conf) {
        return Cache.get(key, conf);
    }

    public void handleCallbacks(List<Callback> var1, String var2, char[] var3) throws UnsupportedCallbackException, IOException;

    public static class DefaultHandler
    implements CustomizedCallbackHandler {
        private static final DefaultHandler INSTANCE = new DefaultHandler();

        @Override
        public void handleCallbacks(List<Callback> callbacks, String username, char[] password) throws UnsupportedCallbackException {
            if (!callbacks.isEmpty()) {
                Callback cb = callbacks.get(0);
                throw new UnsupportedCallbackException(callbacks.get(0), "Unsupported callback: " + (cb == null ? null : cb.getClass()));
            }
        }
    }

    public static class Cache {
        private static final Map<String, CustomizedCallbackHandler> MAP = new HashMap<String, CustomizedCallbackHandler>();

        private static synchronized CustomizedCallbackHandler getSynchronously(String key, Configuration conf) {
            Object created;
            CustomizedCallbackHandler cached = MAP.get(key);
            if (cached != null) {
                return cached;
            }
            Class<?> clazz = conf.getClass(key, DefaultHandler.class);
            LOG.info("{} = {}", (Object)key, clazz);
            if (clazz == DefaultHandler.class) {
                return DefaultHandler.INSTANCE;
            }
            try {
                created = clazz.newInstance();
            }
            catch (Exception e) {
                LOG.warn("Failed to create a new instance of {}, fallback to {}", new Object[]{clazz, DefaultHandler.class, e});
                return DefaultHandler.INSTANCE;
            }
            CustomizedCallbackHandler handler = created instanceof CustomizedCallbackHandler ? (CustomizedCallbackHandler)created : CustomizedCallbackHandler.delegate(created);
            MAP.put(key, handler);
            return handler;
        }

        private static CustomizedCallbackHandler get(String key, Configuration conf) {
            CustomizedCallbackHandler cached = MAP.get(key);
            return cached != null ? cached : Cache.getSynchronously(key, conf);
        }

        public static synchronized void clear() {
            MAP.clear();
        }

        private Cache() {
        }
    }
}

