/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.dynamic;

import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.dynamic.Concatenator;
import org.apache.hadoop.util.dynamic.DynConstructors;
import org.apache.hadoop.util.dynamic.DynMethods;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDynConstructors
extends AbstractHadoopTestBase {
    @Test
    public void testNoImplCall() throws Exception {
        DynConstructors.Builder builder = new DynConstructors.Builder();
        LambdaTestUtils.intercept(NoSuchMethodException.class, () -> ((DynConstructors.Builder)builder).buildChecked());
        LambdaTestUtils.intercept(RuntimeException.class, () -> builder.build());
    }

    @Test
    public void testMissingClass() throws Exception {
        DynConstructors.Builder builder = new DynConstructors.Builder().impl("not.a.RealClass", new Class[0]);
        LambdaTestUtils.intercept(NoSuchMethodException.class, () -> ((DynConstructors.Builder)builder).buildChecked());
        LambdaTestUtils.intercept(RuntimeException.class, () -> ((DynConstructors.Builder)builder).build());
    }

    @Test
    public void testMissingConstructor() throws Exception {
        DynConstructors.Builder builder = new DynConstructors.Builder().impl(Concatenator.class, new Class[]{String.class, String.class});
        LambdaTestUtils.intercept(NoSuchMethodException.class, () -> ((DynConstructors.Builder)builder).buildChecked());
        LambdaTestUtils.intercept(RuntimeException.class, () -> ((DynConstructors.Builder)builder).build());
    }

    @Test
    public void testFirstImplReturned() throws Exception {
        DynConstructors.Ctor sepCtor = new DynConstructors.Builder().impl("not.a.RealClass", new Class[]{String.class}).impl(Concatenator.class, new Class[]{String.class}).impl(Concatenator.class, new Class[0]).buildChecked();
        Concatenator dashCat = (Concatenator)sepCtor.newInstanceChecked(new Object[]{"-"});
        Assertions.assertEquals((Object)"a-b", (Object)dashCat.concat("a", "b"), (String)"Should construct with the 1-arg version");
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> (Concatenator)sepCtor.newInstanceChecked(new Object[]{"/", "-"}));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> (Concatenator)sepCtor.newInstance(new Object[]{"/", "-"}));
        DynConstructors.Ctor defaultCtor = new DynConstructors.Builder().impl("not.a.RealClass", new Class[]{String.class}).impl(Concatenator.class, new Class[0]).impl(Concatenator.class, new Class[]{String.class}).buildChecked();
        Concatenator cat = (Concatenator)defaultCtor.newInstanceChecked(new Object[0]);
        Assertions.assertEquals((Object)"ab", (Object)cat.concat("a", "b"), (String)"Should construct with the no-arg version");
    }

    @Test
    public void testExceptionThrown() throws Exception {
        Concatenator.SomeCheckedException exc = new Concatenator.SomeCheckedException();
        DynConstructors.Ctor sepCtor = new DynConstructors.Builder().impl("not.a.RealClass", new Class[]{String.class}).impl(Concatenator.class, new Class[]{Exception.class}).buildChecked();
        LambdaTestUtils.intercept(Concatenator.SomeCheckedException.class, () -> (Concatenator)sepCtor.newInstanceChecked(new Object[]{exc}));
        LambdaTestUtils.intercept(RuntimeException.class, () -> (Concatenator)sepCtor.newInstance(new Object[]{exc}));
    }

    @Test
    public void testStringClassname() throws Exception {
        DynConstructors.Ctor sepCtor = new DynConstructors.Builder().impl(Concatenator.class.getName(), new Class[]{String.class}).buildChecked();
        Assertions.assertNotNull((Object)sepCtor.newInstance(new Object[]{"-"}), (String)"Should find 1-arg constructor");
    }

    @Test
    public void testHiddenMethod() throws Exception {
        LambdaTestUtils.intercept(NoSuchMethodException.class, () -> new DynMethods.Builder("setSeparator").impl(Concatenator.class, new Class[]{Character.TYPE}).buildChecked());
        DynConstructors.Ctor sepCtor = new DynConstructors.Builder().hiddenImpl(Concatenator.class.getName(), new Class[]{Character.TYPE}).buildChecked();
        Assertions.assertNotNull((Object)sepCtor, (String)"Should find hidden ctor with hiddenImpl");
        Concatenator slashCat = (Concatenator)sepCtor.newInstanceChecked(new Object[]{Character.valueOf('/')});
        Assertions.assertEquals((Object)"a/b", (Object)slashCat.concat("a", "b"), (String)"Should use separator /");
    }

    @Test
    public void testBind() throws Exception {
        DynConstructors.Ctor ctor = new DynConstructors.Builder().impl(Concatenator.class.getName(), new Class[0]).buildChecked();
        Assertions.assertTrue((boolean)ctor.isStatic(), (String)"Should always be static");
        LambdaTestUtils.intercept(IllegalStateException.class, () -> ctor.bind(null));
    }

    @Test
    public void testInvoke() throws Exception {
        DynConstructors.Ctor ctor = new DynConstructors.Builder().impl(Concatenator.class.getName(), new Class[0]).buildChecked();
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> TestDynConstructors.lambda$testInvoke$7((DynMethods.UnboundMethod)ctor));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> TestDynConstructors.lambda$testInvoke$8((DynMethods.UnboundMethod)ctor));
        Assertions.assertNotNull((Object)ctor.invokeChecked(null, new Object[0]), (String)"Should allow invokeChecked(null, ...)");
        Assertions.assertNotNull((Object)ctor.invoke(null, new Object[0]), (String)"Should allow invoke(null, ...)");
    }

    private static /* synthetic */ Object lambda$testInvoke$8(DynMethods.UnboundMethod ctor) throws Exception {
        return ctor.invoke((Object)"a", new Object[0]);
    }

    private static /* synthetic */ Object lambda$testInvoke$7(DynMethods.UnboundMethod ctor) throws Exception {
        return ctor.invokeChecked((Object)"a", new Object[0]);
    }
}

