/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.util.StringInterner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStringInterner {
    @Test
    public void testNoIntern() {
        String literalABC = "ABC";
        String substringABC = "ABCDE".substring(0, 3);
        String heapABC = new String("ABC");
        Assertions.assertNotSame((Object)literalABC, (Object)substringABC);
        Assertions.assertNotSame((Object)literalABC, (Object)heapABC);
        Assertions.assertNotSame((Object)substringABC, (Object)heapABC);
    }

    @Test
    public void testStrongIntern() {
        String strongInternLiteralABC = StringInterner.strongIntern((String)"ABC");
        String strongInternSubstringABC = StringInterner.strongIntern((String)"ABCDE".substring(0, 3));
        String strongInternHeapABC = StringInterner.strongIntern((String)new String("ABC"));
        Assertions.assertSame((Object)strongInternLiteralABC, (Object)strongInternSubstringABC);
        Assertions.assertSame((Object)strongInternLiteralABC, (Object)strongInternHeapABC);
        Assertions.assertSame((Object)strongInternSubstringABC, (Object)strongInternHeapABC);
    }

    @Test
    public void testWeakIntern() {
        String weakInternLiteralABC = StringInterner.weakIntern((String)"ABC");
        String weakInternSubstringABC = StringInterner.weakIntern((String)"ABCDE".substring(0, 3));
        String weakInternHeapABC = StringInterner.weakIntern((String)new String("ABC"));
        Assertions.assertSame((Object)weakInternLiteralABC, (Object)weakInternSubstringABC);
        Assertions.assertSame((Object)weakInternLiteralABC, (Object)weakInternHeapABC);
        Assertions.assertSame((Object)weakInternSubstringABC, (Object)weakInternHeapABC);
    }
}

