/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ShutdownHookManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestShutdownHookManager {
    static final Logger LOG = LoggerFactory.getLogger((String)TestShutdownHookManager.class.getName());
    private final ShutdownHookManager mgr = new ShutdownHookManager();
    private static final AtomicInteger INVOCATION_COUNT = new AtomicInteger();

    @Test
    public void shutdownHookManager() {
        Assertions.assertNotNull((Object)this.mgr, (String)"No ShutdownHookManager");
        Assertions.assertEquals((int)0, (int)this.mgr.getShutdownHooksInOrder().size());
        Hook hook1 = new Hook("hook1", 0L, false);
        Hook hook2 = new Hook("hook2", 0L, false);
        Hook hook3 = new Hook("hook3", 1000L, false);
        Hook hook4 = new Hook("hook4", 25000L, true);
        Hook hook5 = new Hook("hook5", 31000L, true);
        this.mgr.addShutdownHook((Runnable)hook1, 0);
        Assertions.assertTrue((boolean)this.mgr.hasShutdownHook((Runnable)hook1));
        Assertions.assertEquals((int)1, (int)this.mgr.getShutdownHooksInOrder().size());
        Assertions.assertEquals((Object)hook1, (Object)((ShutdownHookManager.HookEntry)this.mgr.getShutdownHooksInOrder().get(0)).getHook());
        Assertions.assertTrue((boolean)this.mgr.removeShutdownHook((Runnable)hook1));
        Assertions.assertFalse((boolean)this.mgr.hasShutdownHook((Runnable)hook1));
        Assertions.assertFalse((boolean)this.mgr.removeShutdownHook((Runnable)hook1));
        this.mgr.addShutdownHook((Runnable)hook1, 0);
        Assertions.assertTrue((boolean)this.mgr.hasShutdownHook((Runnable)hook1));
        Assertions.assertEquals((int)1, (int)this.mgr.getShutdownHooksInOrder().size());
        Assertions.assertEquals((long)30L, (long)((ShutdownHookManager.HookEntry)this.mgr.getShutdownHooksInOrder().get(0)).getTimeout());
        this.mgr.addShutdownHook((Runnable)hook2, 1);
        Assertions.assertTrue((boolean)this.mgr.hasShutdownHook((Runnable)hook1));
        Assertions.assertTrue((boolean)this.mgr.hasShutdownHook((Runnable)hook2));
        Assertions.assertEquals((int)2, (int)this.mgr.getShutdownHooksInOrder().size());
        Assertions.assertEquals((Object)hook2, (Object)((ShutdownHookManager.HookEntry)this.mgr.getShutdownHooksInOrder().get(0)).getHook());
        Assertions.assertEquals((Object)hook1, (Object)((ShutdownHookManager.HookEntry)this.mgr.getShutdownHooksInOrder().get(1)).getHook());
        this.mgr.addShutdownHook((Runnable)hook3, 2, 4L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.mgr.hasShutdownHook((Runnable)hook3));
        Assertions.assertEquals((Object)hook3, (Object)((ShutdownHookManager.HookEntry)this.mgr.getShutdownHooksInOrder().get(0)).getHook());
        Assertions.assertEquals((long)4L, (long)((ShutdownHookManager.HookEntry)this.mgr.getShutdownHooksInOrder().get(0)).getTimeout());
        int hook4timeout = 2;
        this.mgr.addShutdownHook((Runnable)hook4, 3, (long)hook4timeout, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.mgr.hasShutdownHook((Runnable)hook4));
        Assertions.assertEquals((Object)hook4, (Object)((ShutdownHookManager.HookEntry)this.mgr.getShutdownHooksInOrder().get(0)).getHook());
        Assertions.assertEquals((long)2L, (long)((ShutdownHookManager.HookEntry)this.mgr.getShutdownHooksInOrder().get(0)).getTimeout());
        this.mgr.addShutdownHook((Runnable)hook5, 5);
        ShutdownHookManager.HookEntry hookEntry5 = (ShutdownHookManager.HookEntry)this.mgr.getShutdownHooksInOrder().get(0);
        Assertions.assertEquals((Object)hook5, (Object)hookEntry5.getHook());
        Assertions.assertEquals((long)ShutdownHookManager.getShutdownTimeout((Configuration)new Configuration()), (long)hookEntry5.getTimeout(), (String)"default timeout not used");
        Assertions.assertEquals((int)5, (int)hookEntry5.getPriority(), (String)"hook priority");
        Assertions.assertTrue((boolean)this.mgr.removeShutdownHook((Runnable)hook5), (String)("failed to remove " + hook5));
        INVOCATION_COUNT.set(0);
        LOG.info("invoking executeShutdown()");
        int timeouts = this.mgr.executeShutdown();
        LOG.info("Shutdown completed");
        Assertions.assertEquals((int)1, (int)timeouts, (String)"Number of timed out hooks");
        List hooks = this.mgr.getShutdownHooksInOrder();
        for (ShutdownHookManager.HookEntry entry : hooks) {
            Hook hook = (Hook)entry.getHook();
            Assertions.assertTrue((boolean)hook.invoked, (String)("Was not invoked " + hook));
            hook.maybeThrowAssertion();
        }
        Assertions.assertEquals((int)1, (int)hook4.invokedOrder, (String)("Expected to be invoked first " + hook4));
        Assertions.assertFalse((boolean)hook4.completed, (String)("Expected to time out " + hook4));
        Assertions.assertTrue((boolean)hook1.completed, (String)("Expected to complete " + hook1));
        long invocationInterval = hook1.startTime - hook4.startTime;
        Assertions.assertTrue((invocationInterval >= (long)(hook4timeout * 1000) ? 1 : 0) != 0, (String)("invocation difference too short " + invocationInterval));
        Assertions.assertTrue((invocationInterval < hook4.sleepTime ? 1 : 0) != 0, (String)("sleeping hook4 blocked other threads for " + invocationInterval));
        this.mgr.clearShutdownHooks();
        Assertions.assertFalse((boolean)this.mgr.hasShutdownHook((Runnable)hook1));
        Assertions.assertEquals((int)0, (int)this.mgr.getShutdownHooksInOrder().size(), (String)"shutdown hook list is not empty");
    }

    @Test
    public void testShutdownTimeoutConfiguration() throws Throwable {
        Configuration conf = new Configuration();
        long shutdownTimeout = 5L;
        conf.setTimeDuration("hadoop.service.shutdown.timeout", shutdownTimeout, TimeUnit.SECONDS);
        Assertions.assertEquals((long)shutdownTimeout, (long)ShutdownHookManager.getShutdownTimeout((Configuration)conf), (String)"hadoop.service.shutdown.timeout");
    }

    @Test
    public void testShutdownTimeoutBadConfiguration() throws Throwable {
        Configuration conf = new Configuration();
        long shutdownTimeout = 50L;
        conf.setTimeDuration("hadoop.service.shutdown.timeout", shutdownTimeout, TimeUnit.NANOSECONDS);
        Assertions.assertEquals((long)1L, (long)ShutdownHookManager.getShutdownTimeout((Configuration)conf), (String)"hadoop.service.shutdown.timeout");
    }

    @Test
    public void testDuplicateRegistration() throws Throwable {
        Hook hook = new Hook("hook1", 0L, false);
        this.mgr.addShutdownHook((Runnable)hook, 2, 1L, TimeUnit.SECONDS);
        this.mgr.addShutdownHook((Runnable)hook, 5);
        List hookList = this.mgr.getShutdownHooksInOrder();
        Assertions.assertEquals((int)1, (int)hookList.size(), (String)"Hook added twice");
        ShutdownHookManager.HookEntry entry = (ShutdownHookManager.HookEntry)hookList.get(0);
        Assertions.assertEquals((int)2, (int)entry.getPriority(), (String)"priority of hook");
        Assertions.assertEquals((long)1L, (long)entry.getTimeout(), (String)"timeout of hook");
        Assertions.assertTrue((boolean)this.mgr.removeShutdownHook((Runnable)hook), (String)("failed to remove hook " + hook));
        Assertions.assertFalse((boolean)this.mgr.removeShutdownHook((Runnable)hook), (String)"expected hook removal to fail");
        this.mgr.addShutdownHook((Runnable)hook, 5);
        hookList = this.mgr.getShutdownHooksInOrder();
        entry = (ShutdownHookManager.HookEntry)hookList.get(0);
        Assertions.assertEquals((int)5, (int)entry.getPriority(), (String)"priority of hook");
        Assertions.assertNotEquals((long)1L, (long)entry.getTimeout(), (String)"timeout of hook");
    }

    @Test
    public void testShutdownRemove() throws Throwable {
        Assertions.assertNotNull((Object)this.mgr, (String)"No ShutdownHookManager");
        Assertions.assertEquals((int)0, (int)this.mgr.getShutdownHooksInOrder().size());
        Hook hook1 = new Hook("hook1", 0L, false);
        Hook hook2 = new Hook("hook2", 0L, false);
        this.mgr.addShutdownHook((Runnable)hook1, 9);
        Assertions.assertTrue((boolean)this.mgr.hasShutdownHook((Runnable)hook1), (String)"No hook1");
        Assertions.assertEquals((int)1, (int)this.mgr.getShutdownHooksInOrder().size());
        Assertions.assertFalse((boolean)this.mgr.removeShutdownHook((Runnable)hook2), (String)"Delete hook2 should not be allowed");
        Assertions.assertTrue((boolean)this.mgr.removeShutdownHook((Runnable)hook1), (String)"Can't delete hook1");
        Assertions.assertEquals((int)0, (int)this.mgr.getShutdownHooksInOrder().size());
    }

    private class Hook
    implements Runnable {
        private final String name;
        private final long sleepTime;
        private final boolean expectFailure;
        private AssertionError assertion;
        private boolean invoked;
        private int invokedOrder;
        private boolean completed;
        private boolean interrupted;
        private long startTime;

        Hook(String name, long sleepTime, boolean expectFailure) {
            this.name = name;
            this.sleepTime = sleepTime;
            this.expectFailure = expectFailure;
        }

        @Override
        public void run() {
            block4: {
                try {
                    this.invoked = true;
                    this.invokedOrder = INVOCATION_COUNT.incrementAndGet();
                    this.startTime = System.currentTimeMillis();
                    LOG.info("Starting shutdown of {} with sleep time of {}", (Object)this.name, (Object)this.sleepTime);
                    if (this.sleepTime > 0L) {
                        Thread.sleep(this.sleepTime);
                    }
                    LOG.info("Completed shutdown of {}", (Object)this.name);
                    this.completed = true;
                    if (this.expectFailure) {
                        this.assertion = new AssertionError((Object)("Expected a failure of " + this.name));
                    }
                }
                catch (InterruptedException ex) {
                    LOG.info("Shutdown {} interrupted exception", (Object)this.name, (Object)ex);
                    this.interrupted = true;
                    if (this.expectFailure) break block4;
                    this.assertion = new AssertionError("Timeout of " + this.name, ex);
                }
            }
            this.maybeThrowAssertion();
        }

        void maybeThrowAssertion() throws AssertionError {
            if (this.assertion != null) {
                throw this.assertion;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Hook{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", sleepTime=").append(this.sleepTime);
            sb.append(", expectFailure=").append(this.expectFailure);
            sb.append(", invoked=").append(this.invoked);
            sb.append(", invokedOrder=").append(this.invokedOrder);
            sb.append(", completed=").append(this.completed);
            sb.append(", interrupted=").append(this.interrupted);
            sb.append('}');
            return sb.toString();
        }
    }
}

