/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.NativeLibraryChecker;
import org.apache.hadoop.util.Shell;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestNativeLibraryChecker {
    private void expectExit(String[] args) {
        try {
            NativeLibraryChecker.main((String[])args);
            Assertions.fail((String)"should call exit");
        }
        catch (ExitUtil.ExitException e) {
            ExitUtil.resetFirstExitException();
        }
    }

    @Test
    public void testNativeLibraryChecker() {
        ExitUtil.disableSystemExit();
        NativeLibraryChecker.main((String[])new String[]{"-h"});
        this.expectExit(new String[]{"-a", "-h"});
        this.expectExit(new String[]{"aaa"});
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            NativeLibraryChecker.main((String[])new String[0]);
        } else {
            this.expectExit(new String[0]);
        }
    }

    @Test
    public void testNativeLibraryCheckerOutput() {
        this.expectOutput(new String[]{"-a"});
        this.expectOutput(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expectOutput(String[] args) {
        PrintStream originalPs;
        ByteArrayOutputStream outContent;
        block8: {
            ExitUtil.disableSystemExit();
            outContent = new ByteArrayOutputStream();
            originalPs = System.out;
            System.setOut(new PrintStream(outContent));
            try {
                NativeLibraryChecker.main((String[])args);
                if (!Shell.WINDOWS) break block8;
                Assertions.assertEquals((Object)(outContent.toString().indexOf("winutils: true") != -1 ? 1 : 0), (Object)true);
            }
            catch (ExitUtil.ExitException e) {
                block9: {
                    try {
                        ExitUtil.resetFirstExitException();
                        if (!Shell.WINDOWS) break block9;
                        Assertions.assertEquals((Object)(outContent.toString().indexOf("winutils: true") != -1 ? 1 : 0), (Object)true);
                    }
                    catch (Throwable throwable) {
                        if (Shell.WINDOWS) {
                            Assertions.assertEquals((Object)(outContent.toString().indexOf("winutils: true") != -1 ? 1 : 0), (Object)true);
                        }
                        if (NativeCodeLoader.isNativeCodeLoaded()) {
                            Assertions.assertEquals((Object)(outContent.toString().indexOf("hadoop:  true") != -1 ? 1 : 0), (Object)true);
                        }
                        System.setOut(originalPs);
                        throw throwable;
                    }
                }
                if (NativeCodeLoader.isNativeCodeLoaded()) {
                    Assertions.assertEquals((Object)(outContent.toString().indexOf("hadoop:  true") != -1 ? 1 : 0), (Object)true);
                }
                System.setOut(originalPs);
            }
        }
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            Assertions.assertEquals((Object)(outContent.toString().indexOf("hadoop:  true") != -1 ? 1 : 0), (Object)true);
        }
        System.setOut(originalPs);
    }
}

