/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.LineReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLineReader {
    @Test
    public void testCustomDelimiter1() throws Exception {
        String delimiter = "</entity>";
        String currentBufferTailToken = "</entity><entity><id>Gelesh</";
        String nextBufferHeadToken = "id><name>Omathil</name></entity>";
        String expected = "</entity><entity><id>Gelesh</id><name>Omathil</name></entity>".replace("</entity>", "");
        String testPartOfInput = "</entity><entity><id>Gelesh</id><name>Omathil</name></entity>";
        int bufferSize = 65536;
        int numberOfCharToFillTheBuffer = 65536 - "</entity><entity><id>Gelesh</".length();
        char[] fillBuffer = new char[numberOfCharToFillTheBuffer];
        Arrays.fill(fillBuffer, 'a');
        StringBuilder fillerString = new StringBuilder();
        String testData = fillerString + "</entity><entity><id>Gelesh</id><name>Omathil</name></entity>";
        LineReader lineReader = new LineReader((InputStream)new ByteArrayInputStream(testData.getBytes(StandardCharsets.UTF_8)), "</entity>".getBytes(StandardCharsets.UTF_8));
        Text line = new Text();
        lineReader.readLine(line);
        lineReader.close();
        Assertions.assertEquals((Object)fillerString.toString(), (Object)line.toString());
        lineReader.readLine(line);
        Assertions.assertEquals((Object)expected, (Object)line.toString());
    }

    @Test
    public void testCustomDelimiter2() throws Exception {
        String delimiter = "record";
        StringBuilder testStringBuilder = new StringBuilder();
        testStringBuilder.append("record").append("Kerala ");
        testStringBuilder.append("record").append("Bangalore");
        testStringBuilder.append("record").append(" North Korea");
        testStringBuilder.append("record").append("record").append("Guantanamo");
        testStringBuilder.append("recordecordrecorcore");
        String testData = testStringBuilder.toString();
        LineReader lineReader = new LineReader((InputStream)new ByteArrayInputStream(testData.getBytes(StandardCharsets.UTF_8)), "record".getBytes(StandardCharsets.UTF_8));
        Text line = new Text();
        lineReader.readLine(line);
        Assertions.assertEquals((Object)"", (Object)line.toString());
        lineReader.readLine(line);
        Assertions.assertEquals((Object)"Kerala ", (Object)line.toString());
        lineReader.readLine(line);
        Assertions.assertEquals((Object)"Bangalore", (Object)line.toString());
        lineReader.readLine(line);
        Assertions.assertEquals((Object)" North Korea", (Object)line.toString());
        lineReader.readLine(line);
        Assertions.assertEquals((Object)"", (Object)line.toString());
        lineReader.readLine(line);
        Assertions.assertEquals((Object)"Guantanamo", (Object)line.toString());
        lineReader.readLine(line);
        Assertions.assertEquals((Object)"ecordrecorcore", (Object)line.toString());
        lineReader.close();
    }

    @Test
    public void testCustomDelimiter3() throws Exception {
        String testData = "aaaabccc";
        String delimiter = "aaab";
        LineReader lineReader = new LineReader((InputStream)new ByteArrayInputStream("aaaabccc".getBytes(StandardCharsets.UTF_8)), "aaab".getBytes(StandardCharsets.UTF_8));
        Text line = new Text();
        lineReader.readLine(line);
        Assertions.assertEquals((Object)"a", (Object)line.toString());
        lineReader.readLine(line);
        Assertions.assertEquals((Object)"ccc", (Object)line.toString());
        lineReader.close();
    }
}

