/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.util.AutoCloseableLock;
import org.apache.hadoop.util.InstrumentedLock;
import org.apache.hadoop.util.Timer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestInstrumentedLock {
    static final Logger LOG = LoggerFactory.getLogger(TestInstrumentedLock.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10L)
    public void testMultipleThread(TestInfo testInfo) throws Exception {
        String testname = testInfo.getDisplayName();
        final InstrumentedLock lock = new InstrumentedLock(testname, LOG, 0L, 300L);
        lock.lock();
        try {
            Thread competingThread = new Thread(){

                @Override
                public void run() {
                    Assertions.assertFalse((boolean)lock.tryLock());
                }
            };
            competingThread.start();
            competingThread.join();
        }
        finally {
            lock.unlock();
        }
    }

    @Test
    @Timeout(value=10L)
    public void testTryWithResourceSyntax(TestInfo testInfo) throws Exception {
        String testname = testInfo.getDisplayName();
        final AtomicReference<Object> lockThread = new AtomicReference<Object>(null);
        InstrumentedLock lock = new InstrumentedLock(testname, LOG, 0L, 300L){

            public void lock() {
                super.lock();
                lockThread.set(Thread.currentThread());
            }

            public void unlock() {
                super.unlock();
                lockThread.set(null);
            }
        };
        AutoCloseableLock acl = new AutoCloseableLock((Lock)lock);
        try (AutoCloseableLock localLock = acl.acquire();){
            Assertions.assertEquals((Object)acl, (Object)localLock);
            Thread competingThread = new Thread((Lock)lock){
                final /* synthetic */ Lock val$lock;
                {
                    this.val$lock = lock;
                }

                @Override
                public void run() {
                    Assertions.assertNotEquals((Object)Thread.currentThread(), lockThread.get());
                    Assertions.assertFalse((boolean)this.val$lock.tryLock());
                }
            };
            competingThread.start();
            competingThread.join();
            Assertions.assertEquals((Object)Thread.currentThread(), lockThread.get());
        }
        Assertions.assertNull(lockThread.get());
    }

    @Test
    @Timeout(value=10L)
    public void testLockLongHoldingReport(TestInfo testInfo) throws Exception {
        String testname = testInfo.getDisplayName();
        final AtomicLong time = new AtomicLong(0L);
        Timer mclock = new Timer(){

            public long monotonicNow() {
                return time.get();
            }
        };
        Lock mlock = (Lock)Mockito.mock(Lock.class);
        final AtomicLong wlogged = new AtomicLong(0L);
        final AtomicLong wsuppresed = new AtomicLong(0L);
        final AtomicLong wMaxWait = new AtomicLong(0L);
        InstrumentedLock lock = new InstrumentedLock(testname, LOG, mlock, 2000L, 300L, mclock){

            void logWarning(long lockHeldTime, InstrumentedLock.SuppressedSnapshot stats) {
                wlogged.incrementAndGet();
                wsuppresed.set(stats.getSuppressedCount());
                wMaxWait.set(stats.getMaxSuppressedWait());
            }
        };
        lock.lock();
        time.set(200L);
        lock.unlock();
        Assertions.assertEquals((long)0L, (long)wlogged.get());
        Assertions.assertEquals((long)0L, (long)wsuppresed.get());
        Assertions.assertEquals((long)0L, (long)wMaxWait.get());
        lock.lock();
        time.set(700L);
        lock.unlock();
        Assertions.assertEquals((long)1L, (long)wlogged.get());
        Assertions.assertEquals((long)0L, (long)wsuppresed.get());
        Assertions.assertEquals((long)0L, (long)wMaxWait.get());
        lock.lock();
        time.set(1100L);
        lock.unlock();
        Assertions.assertEquals((long)1L, (long)wlogged.get());
        Assertions.assertEquals((long)0L, (long)wsuppresed.get());
        Assertions.assertEquals((long)0L, (long)wMaxWait.get());
        time.set(2400L);
        lock.lock();
        time.set(2800L);
        lock.unlock();
        Assertions.assertEquals((long)2L, (long)wlogged.get());
        Assertions.assertEquals((long)1L, (long)wsuppresed.get());
        Assertions.assertEquals((long)400L, (long)wMaxWait.get());
    }

    @Test
    @Timeout(value=10L)
    public void testLockLongWaitReport(TestInfo testInfo) throws Exception {
        String testname = testInfo.getDisplayName();
        final AtomicLong time = new AtomicLong(0L);
        Timer mclock = new Timer(){

            public long monotonicNow() {
                return time.get();
            }
        };
        ReentrantLock mlock = new ReentrantLock(true);
        final AtomicLong wlogged = new AtomicLong(0L);
        final AtomicLong wsuppresed = new AtomicLong(0L);
        final AtomicLong wMaxWait = new AtomicLong(0L);
        InstrumentedLock lock = new InstrumentedLock(testname, LOG, mlock, 2000L, 300L, mclock){

            void logWaitWarning(long lockHeldTime, InstrumentedLock.SuppressedSnapshot stats) {
                wlogged.incrementAndGet();
                wsuppresed.set(stats.getSuppressedCount());
                wMaxWait.set(stats.getMaxSuppressedWait());
            }
        };
        lock.lock();
        Thread competingThread = this.lockUnlockThread((Lock)lock);
        time.set(200L);
        lock.unlock();
        competingThread.join();
        Assertions.assertEquals((long)0L, (long)wlogged.get());
        Assertions.assertEquals((long)0L, (long)wsuppresed.get());
        Assertions.assertEquals((long)0L, (long)wMaxWait.get());
        lock.lock();
        competingThread = this.lockUnlockThread((Lock)lock);
        time.set(700L);
        lock.unlock();
        competingThread.join();
        Assertions.assertEquals((long)1L, (long)wlogged.get());
        Assertions.assertEquals((long)0L, (long)wsuppresed.get());
        Assertions.assertEquals((long)0L, (long)wMaxWait.get());
        lock.lock();
        competingThread = this.lockUnlockThread((Lock)lock);
        time.set(1100L);
        lock.unlock();
        competingThread.join();
        Assertions.assertEquals((long)1L, (long)wlogged.get());
        Assertions.assertEquals((long)0L, (long)wsuppresed.get());
        Assertions.assertEquals((long)0L, (long)wMaxWait.get());
        time.set(2400L);
        lock.lock();
        competingThread = this.lockUnlockThread((Lock)lock);
        time.set(2800L);
        lock.unlock();
        competingThread.join();
        Assertions.assertEquals((long)2L, (long)wlogged.get());
        Assertions.assertEquals((long)1L, (long)wsuppresed.get());
        Assertions.assertEquals((long)400L, (long)wMaxWait.get());
    }

    private Thread lockUnlockThread(Lock lock) throws InterruptedException {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Thread t = new Thread(() -> {
            try {
                Assertions.assertFalse((boolean)lock.tryLock());
                countDownLatch.countDown();
                lock.lock();
            }
            finally {
                lock.unlock();
            }
        });
        t.start();
        countDownLatch.await();
        Thread.sleep(3L);
        return t;
    }
}

