/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.hadoop.util.IdentityHashStore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestIdentityHashStore {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestIdentityHashStore.class.getName());

    @Test
    @Timeout(value=60L)
    public void testStartingWithZeroCapacity() {
        IdentityHashStore store = new IdentityHashStore(0);
        store.visitAll((IdentityHashStore.Visitor)new IdentityHashStore.Visitor<Key, Integer>(){

            public void accept(Key k, Integer v) {
                Assertions.fail((String)("found key " + k + " in empty IdentityHashStore."));
            }
        });
        Assertions.assertTrue((boolean)store.isEmpty());
        final Key key1 = new Key("key1");
        Integer value1 = new Integer(100);
        store.put((Object)key1, (Object)value1);
        Assertions.assertTrue((!store.isEmpty() ? 1 : 0) != 0);
        Assertions.assertEquals((Integer)value1, (Integer)((Integer)store.get((Object)key1)));
        store.visitAll((IdentityHashStore.Visitor)new IdentityHashStore.Visitor<Key, Integer>(){

            public void accept(Key k, Integer v) {
                Assertions.assertEquals((Object)key1, (Object)k);
            }
        });
        Assertions.assertEquals((Integer)value1, (Integer)((Integer)store.remove((Object)key1)));
        Assertions.assertTrue((boolean)store.isEmpty());
    }

    @Test
    @Timeout(value=60L)
    public void testDuplicateInserts() {
        IdentityHashStore store = new IdentityHashStore(4);
        store.visitAll((IdentityHashStore.Visitor)new IdentityHashStore.Visitor<Key, Integer>(){

            public void accept(Key k, Integer v) {
                Assertions.fail((String)("found key " + k + " in empty IdentityHashStore."));
            }
        });
        Assertions.assertTrue((boolean)store.isEmpty());
        Key key1 = new Key("key1");
        Integer value1 = new Integer(100);
        Integer value2 = new Integer(200);
        Integer value3 = new Integer(300);
        store.put((Object)key1, (Object)value1);
        Key equalToKey1 = new Key("key1");
        Assertions.assertNull((Object)store.get((Object)equalToKey1));
        Assertions.assertTrue((!store.isEmpty() ? 1 : 0) != 0);
        Assertions.assertEquals((Integer)value1, (Integer)((Integer)store.get((Object)key1)));
        store.put((Object)key1, (Object)value2);
        store.put((Object)key1, (Object)value3);
        final LinkedList allValues = new LinkedList();
        store.visitAll((IdentityHashStore.Visitor)new IdentityHashStore.Visitor<Key, Integer>(){

            public void accept(Key k, Integer v) {
                allValues.add(v);
            }
        });
        Assertions.assertEquals((int)3, (int)allValues.size());
        for (int i = 0; i < 3; ++i) {
            Integer value = (Integer)store.remove((Object)key1);
            Assertions.assertTrue((boolean)allValues.remove(value));
        }
        Assertions.assertNull((Object)store.remove((Object)key1));
        Assertions.assertTrue((boolean)store.isEmpty());
    }

    @Test
    @Timeout(value=60L)
    public void testAdditionsAndRemovals() {
        int i;
        IdentityHashStore store = new IdentityHashStore(0);
        int NUM_KEYS = 1000;
        LOG.debug("generating 1000 keys");
        final ArrayList<Key> keys = new ArrayList<Key>(1000);
        for (i = 0; i < 1000; ++i) {
            keys.add(new Key("key " + i));
        }
        for (i = 0; i < 1000; ++i) {
            store.put(keys.get(i), (Object)i);
        }
        store.visitAll((IdentityHashStore.Visitor)new IdentityHashStore.Visitor<Key, Integer>(){

            public void accept(Key k, Integer v) {
                Assertions.assertTrue((boolean)keys.contains(k));
            }
        });
        for (i = 0; i < 1000; ++i) {
            Assertions.assertEquals((Integer)i, (Integer)((Integer)store.remove(keys.get(i))));
        }
        store.visitAll((IdentityHashStore.Visitor)new IdentityHashStore.Visitor<Key, Integer>(){

            public void accept(Key k, Integer v) {
                Assertions.fail((String)"expected all entries to be removed");
            }
        });
        Assertions.assertTrue((boolean)store.isEmpty(), (String)("expected the store to be empty, but found " + store.numElements() + " elements."));
        Assertions.assertEquals((int)1024, (int)store.capacity());
    }

    private static class Key {
        private final String name;

        Key(String name) {
            this.name = name;
        }

        public int hashCode() {
            throw new RuntimeException("should not be used!");
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            return this.name.equals(other.name);
        }
    }
}

