/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.GenericsUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGenericsUtil {
    @Test
    public void testToArray() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 10; ++i) {
            list.add(i);
        }
        Integer[] arr = (Integer[])GenericsUtil.toArray(list);
        for (int i = 0; i < arr.length; ++i) {
            Assertions.assertEquals((Integer)((Integer)list.get(i)), (Integer)arr[i], (String)"Array has identical elements as input list");
        }
    }

    @Test
    public void testWithEmptyList() {
        try {
            ArrayList list = new ArrayList();
            String[] arr = (String[])GenericsUtil.toArray(list);
            Assertions.fail((String)"Empty array should throw exception");
            System.out.println(arr);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testWithEmptyList2() {
        ArrayList list = new ArrayList();
        String[] arr = (String[])GenericsUtil.toArray(String.class, list);
        Assertions.assertEquals((int)0, (int)arr.length, (String)"Assert list creation w/ no elements results in length 0");
    }

    @Test
    public void testWithGenericClass() {
        GenericClass<String> testSubject = new GenericClass<String>();
        testSubject.add("test1");
        testSubject.add("test2");
        try {
            String[] arr = (String[])testSubject.funcThatUsesToArray();
            Assertions.assertEquals((Object)"test1", (Object)arr[0]);
            Assertions.assertEquals((Object)"test2", (Object)arr[1]);
        }
        catch (ClassCastException ex) {
            Assertions.fail((String)"GenericsUtil#toArray() is not working for generic classes");
        }
    }

    @Test
    public void testGenericOptionsParser() throws Exception {
        GenericOptionsParser parser = new GenericOptionsParser(new Configuration(), new String[]{"-jt"});
        Assertions.assertEquals((int)0, (int)parser.getRemainingArgs().length);
        parser = new GenericOptionsParser(new Configuration(), new String[]{"-Dx=y=z"});
        Assertions.assertEquals((Object)"y=z", (Object)parser.getConfiguration().get("x"), (String)"Options parser gets entire ='s expresion");
    }

    @Test
    public void testGetClass() {
        Integer x = new Integer(42);
        Class c = GenericsUtil.getClass((Object)x);
        Assertions.assertEquals(Integer.class, (Object)c, (String)"Correct generic type is acquired from object");
        GenericClass testSubject = new GenericClass();
        Class c2 = GenericsUtil.getClass(testSubject);
        Assertions.assertEquals(GenericClass.class, (Object)c2, (String)"Inner generics are acquired from object.");
    }

    @Test
    public void testIsLog4jLogger() throws Exception {
        Assertions.assertFalse((boolean)GenericsUtil.isLog4jLogger((Class)null), (String)"False if clazz is null");
        Assertions.assertTrue((boolean)GenericsUtil.isLog4jLogger(TestGenericsUtil.class), (String)"The implementation is Log4j");
    }

    private class GenericClass<T> {
        T dummy;
        List<T> list = new ArrayList<T>();

        private GenericClass() {
        }

        void add(T item) {
            this.list.add(item);
        }

        T[] funcThatUsesToArray() {
            Object[] arr = GenericsUtil.toArray(this.list);
            return arr;
        }
    }
}

