/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.ExitUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestExitUtil
extends AbstractHadoopTestBase {
    @BeforeEach
    public void before() {
        ExitUtil.disableSystemExit();
        ExitUtil.disableSystemHalt();
        ExitUtil.resetFirstExitException();
        ExitUtil.resetFirstHaltException();
    }

    @AfterEach
    public void after() {
        ExitUtil.resetFirstExitException();
        ExitUtil.resetFirstHaltException();
    }

    @Test
    public void testGetSetExitExceptions() throws Throwable {
        ExitUtil.ExitException ee1 = new ExitUtil.ExitException(1, "TestExitUtil forged 1st ExitException");
        ExitUtil.ExitException ee2 = new ExitUtil.ExitException(2, "TestExitUtil forged 2nd ExitException");
        Assertions.assertFalse((boolean)ExitUtil.terminateCalled(), (String)"ExitUtil.terminateCalled initial value should be false");
        Assertions.assertNull((Object)((Object)ExitUtil.getFirstExitException()), (String)"ExitUtil.getFirstExitException initial value should be null");
        ExitUtil.ExitException ee = LambdaTestUtils.intercept(ExitUtil.ExitException.class, () -> ExitUtil.terminate((ExitUtil.ExitException)ee1));
        Assertions.assertSame((Object)((Object)ee1), (Object)((Object)ee), (String)"ExitUtil.terminate should have rethrown its ExitException argument but it had thrown something else");
        Assertions.assertTrue((boolean)ExitUtil.terminateCalled(), (String)"ExitUtil.terminateCalled should be true after 1st ExitUtil.terminate call");
        Assertions.assertSame((Object)((Object)ee1), (Object)((Object)ExitUtil.getFirstExitException()), (String)"ExitUtil.terminate should store its 1st call's ExitException");
        ee = LambdaTestUtils.intercept(ExitUtil.ExitException.class, () -> ExitUtil.terminate((ExitUtil.ExitException)ee2));
        Assertions.assertSame((Object)((Object)ee2), (Object)((Object)ee), (String)"ExitUtil.terminate should have rethrown its HaltException argument but it had thrown something else");
        Assertions.assertTrue((boolean)ExitUtil.terminateCalled(), (String)"ExitUtil.terminateCalled should still be true after 2nd ExitUtil.terminate call");
        Assertions.assertSame((Object)((Object)ee1), (Object)((Object)ExitUtil.getFirstExitException()), (String)"ExitUtil.terminate when called twice should only remember 1st call's ExitException");
        ExitUtil.resetFirstExitException();
        Assertions.assertFalse((boolean)ExitUtil.terminateCalled(), (String)"ExitUtil.terminateCalled should be false after ExitUtil.resetFirstExitException call");
        Assertions.assertNull((Object)((Object)ExitUtil.getFirstExitException()), (String)"ExitUtil.getFirstExitException should be null after ExitUtil.resetFirstExitException call");
    }

    @Test
    public void testGetSetHaltExceptions() throws Throwable {
        ExitUtil.disableSystemHalt();
        ExitUtil.resetFirstHaltException();
        ExitUtil.HaltException he1 = new ExitUtil.HaltException(1, "TestExitUtil forged 1st HaltException");
        ExitUtil.HaltException he2 = new ExitUtil.HaltException(2, "TestExitUtil forged 2nd HaltException");
        Assertions.assertFalse((boolean)ExitUtil.haltCalled(), (String)"ExitUtil.haltCalled initial value should be false");
        Assertions.assertNull((Object)((Object)ExitUtil.getFirstHaltException()), (String)"ExitUtil.getFirstHaltException initial value should be null");
        ExitUtil.HaltException he = LambdaTestUtils.intercept(ExitUtil.HaltException.class, () -> ExitUtil.halt((ExitUtil.HaltException)he1));
        Assertions.assertSame((Object)((Object)he1), (Object)((Object)he), (String)"ExitUtil.halt should have rethrown its HaltException argument but it had thrown something else");
        Assertions.assertTrue((boolean)ExitUtil.haltCalled(), (String)"ExitUtil.haltCalled should be true after 1st ExitUtil.halt call");
        Assertions.assertSame((Object)((Object)he1), (Object)((Object)ExitUtil.getFirstHaltException()), (String)"ExitUtil.halt should store its 1st call's HaltException");
        he = LambdaTestUtils.intercept(ExitUtil.HaltException.class, () -> ExitUtil.halt((ExitUtil.HaltException)he2));
        Assertions.assertSame((Object)((Object)he2), (Object)((Object)he), (String)"ExitUtil.halt should have rethrown its HaltException argument but it had thrown something else");
        Assertions.assertTrue((boolean)ExitUtil.haltCalled(), (String)"ExitUtil.haltCalled should still be true after 2nd ExitUtil.halt call");
        Assertions.assertSame((Object)((Object)he1), (Object)((Object)ExitUtil.getFirstHaltException()), (String)"ExitUtil.halt when called twice should only remember 1st call's HaltException");
        ExitUtil.resetFirstHaltException();
        Assertions.assertFalse((boolean)ExitUtil.haltCalled(), (String)"ExitUtil.haltCalled should be false after ExitUtil.resetFirstHaltException call");
        Assertions.assertNull((Object)((Object)ExitUtil.getFirstHaltException()), (String)"ExitUtil.getFirstHaltException should be null after ExitUtil.resetFirstHaltException call");
    }
}

