/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.hadoop.util.ConfTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConfTest {
    @Test
    public void testEmptyConfiguration() {
        String conf = "<configuration/>";
        ByteArrayInputStream bais = new ByteArrayInputStream(conf.getBytes());
        List errors = ConfTest.checkConf((InputStream)bais);
        Assertions.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    public void testValidConfiguration() {
        String conf = "<configuration>\n<property>\n<name>foo</name>\n<value>bar</value>\n</property>\n</configuration>";
        ByteArrayInputStream bais = new ByteArrayInputStream(conf.getBytes());
        List errors = ConfTest.checkConf((InputStream)bais);
        Assertions.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    public void testSourceDuplicationIsValid() {
        String conf = "<configuration>\n<property source='a'>\n<name>foo</name>\n<value>bar</value>\n<source>b</source>\n<source>c</source>\n</property>\n</configuration>";
        ByteArrayInputStream bais = new ByteArrayInputStream(conf.getBytes());
        List errors = ConfTest.checkConf((InputStream)bais);
        Assertions.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    public void testEmptyInput() {
        String conf = "";
        ByteArrayInputStream bais = new ByteArrayInputStream(conf.getBytes());
        List errors = ConfTest.checkConf((InputStream)bais);
        Assertions.assertEquals((int)1, (int)errors.size());
        Assertions.assertTrue((boolean)((String)errors.get(0)).startsWith("bad conf file: "));
    }

    @Test
    public void testInvalidFormat() {
        String conf = "<configuration>";
        ByteArrayInputStream bais = new ByteArrayInputStream(conf.getBytes());
        List errors = ConfTest.checkConf((InputStream)bais);
        Assertions.assertEquals((int)1, (int)errors.size());
        Assertions.assertTrue((boolean)((String)errors.get(0)).startsWith("bad conf file: "));
    }

    @Test
    public void testRootElementNotConfiguration() {
        String conf = "<configurations/>";
        ByteArrayInputStream bais = new ByteArrayInputStream(conf.getBytes());
        List errors = ConfTest.checkConf((InputStream)bais);
        Assertions.assertEquals((int)1, (int)errors.size());
        Assertions.assertEquals((Object)"bad conf file: top-level element not <configuration>", errors.get(0));
    }

    @Test
    public void testSubElementNotProperty() {
        String conf = "<configuration>\n<foo/>\n</configuration>";
        ByteArrayInputStream bais = new ByteArrayInputStream(conf.getBytes());
        List errors = ConfTest.checkConf((InputStream)bais);
        Assertions.assertEquals((int)1, (int)errors.size());
        Assertions.assertEquals((Object)"Line 2: element not <property>", errors.get(0));
    }

    @Test
    public void testPropertyHasNoName() {
        String conf = "<configuration>\n<property>\n<value>foo</value>\n</property>\n</configuration>";
        ByteArrayInputStream bais = new ByteArrayInputStream(conf.getBytes());
        List errors = ConfTest.checkConf((InputStream)bais);
        Assertions.assertEquals((int)1, (int)errors.size());
        Assertions.assertEquals((Object)"Line 2: <property> has no <name>", errors.get(0));
    }

    @Test
    public void testPropertyHasEmptyName() {
        String conf = "<configuration>\n<property>\n<name></name>\n<value>foo</value>\n</property>\n</configuration>";
        ByteArrayInputStream bais = new ByteArrayInputStream(conf.getBytes());
        List errors = ConfTest.checkConf((InputStream)bais);
        Assertions.assertEquals((int)1, (int)errors.size());
        Assertions.assertEquals((Object)"Line 2: <property> has an empty <name>", errors.get(0));
    }

    @Test
    public void testPropertyHasNoValue() {
        String conf = "<configuration>\n<property>\n<name>foo</name>\n</property>\n</configuration>";
        ByteArrayInputStream bais = new ByteArrayInputStream(conf.getBytes());
        List errors = ConfTest.checkConf((InputStream)bais);
        Assertions.assertEquals((int)1, (int)errors.size());
        Assertions.assertEquals((Object)"Line 2: <property> has no <value>", errors.get(0));
    }

    @Test
    public void testPropertyHasEmptyValue() {
        String conf = "<configuration>\n<property>\n<name>foo</name>\n<value></value>\n</property>\n</configuration>";
        ByteArrayInputStream bais = new ByteArrayInputStream(conf.getBytes());
        List errors = ConfTest.checkConf((InputStream)bais);
        Assertions.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    public void testPropertyHasDuplicatedAttributeAndElement() {
        String conf = "<configuration>\n<property name='foo'>\n<name>bar</name>\n<value>baz</value>\n</property>\n</configuration>";
        ByteArrayInputStream bais = new ByteArrayInputStream(conf.getBytes());
        List errors = ConfTest.checkConf((InputStream)bais);
        Assertions.assertEquals((int)1, (int)errors.size());
        Assertions.assertEquals((Object)"Line 2: <property> has duplicated <name>s", errors.get(0));
    }

    @Test
    public void testPropertyHasDuplicatedElements() {
        String conf = "<configuration>\n<property>\n<name>foo</name>\n<name>bar</name>\n<value>baz</value>\n</property>\n</configuration>";
        ByteArrayInputStream bais = new ByteArrayInputStream(conf.getBytes());
        List errors = ConfTest.checkConf((InputStream)bais);
        Assertions.assertEquals((int)1, (int)errors.size());
        Assertions.assertEquals((Object)"Line 2: <property> has duplicated <name>s", errors.get(0));
    }

    @Test
    public void testDuplicatedProperties() {
        String conf = "<configuration>\n<property>\n<name>foo</name>\n<value>bar</value>\n</property>\n<property>\n<name>foo</name>\n<value>baz</value>\n</property>\n</configuration>";
        ByteArrayInputStream bais = new ByteArrayInputStream(conf.getBytes());
        List errors = ConfTest.checkConf((InputStream)bais);
        Assertions.assertEquals((int)1, (int)errors.size());
        Assertions.assertEquals((Object)"Line 2, 6: duplicated <property>s for foo", errors.get(0));
    }
}

