/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.nio.channels.ClosedChannelException;
import org.apache.hadoop.test.HadoopTestBase;
import org.apache.hadoop.util.CloseableReferenceCount;
import org.junit.jupiter.api.Test;

public class TestCloseableReferenceCount
extends HadoopTestBase {
    @Test
    public void testReference() throws ClosedChannelException {
        CloseableReferenceCount clr = new CloseableReferenceCount();
        clr.reference();
        TestCloseableReferenceCount.assertEquals((int)1, (int)clr.getReferenceCount(), (String)"Incorrect reference count");
    }

    @Test
    public void testUnreference() throws ClosedChannelException {
        CloseableReferenceCount clr = new CloseableReferenceCount();
        clr.reference();
        clr.reference();
        TestCloseableReferenceCount.assertFalse((boolean)clr.unreference(), (String)"New reference count should not equal STATUS_CLOSED_MASK");
        TestCloseableReferenceCount.assertEquals((int)1, (int)clr.getReferenceCount(), (String)"Incorrect reference count");
    }

    @Test
    public void testUnreferenceCheckClosed() throws ClosedChannelException {
        CloseableReferenceCount clr = new CloseableReferenceCount();
        clr.reference();
        clr.reference();
        clr.unreferenceCheckClosed();
        TestCloseableReferenceCount.assertEquals((int)1, (int)clr.getReferenceCount(), (String)"Incorrect reference count");
    }

    @Test
    public void testSetClosed() throws ClosedChannelException {
        CloseableReferenceCount clr = new CloseableReferenceCount();
        TestCloseableReferenceCount.assertTrue((boolean)clr.isOpen(), (String)"Reference count should be open");
        clr.setClosed();
        TestCloseableReferenceCount.assertFalse((boolean)clr.isOpen(), (String)"Reference count should be closed");
    }

    @Test
    public void testReferenceClosedReference() throws ClosedChannelException {
        TestCloseableReferenceCount.assertThrows(ClosedChannelException.class, () -> {
            CloseableReferenceCount clr = new CloseableReferenceCount();
            clr.setClosed();
            TestCloseableReferenceCount.assertFalse((boolean)clr.isOpen(), (String)"Reference count should be closed");
            clr.reference();
        });
    }

    @Test
    public void testUnreferenceClosedReference() throws ClosedChannelException {
        TestCloseableReferenceCount.assertThrows(ClosedChannelException.class, () -> {
            CloseableReferenceCount clr = new CloseableReferenceCount();
            clr.reference();
            clr.setClosed();
            TestCloseableReferenceCount.assertFalse((boolean)clr.isOpen(), (String)"Reference count should be closed");
            clr.unreferenceCheckClosed();
        });
    }

    @Test
    public void testDoubleClose() throws ClosedChannelException {
        TestCloseableReferenceCount.assertThrows(ClosedChannelException.class, () -> {
            CloseableReferenceCount clr = new CloseableReferenceCount();
            TestCloseableReferenceCount.assertTrue((boolean)clr.isOpen(), (String)"Reference count should be open");
            clr.setClosed();
            TestCloseableReferenceCount.assertFalse((boolean)clr.isOpen(), (String)"Reference count should be closed");
            clr.setClosed();
        });
    }
}

