/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.util.ChunkedArrayList;
import org.apache.hadoop.util.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestChunkedArrayList {
    @Test
    public void testBasics() {
        int N_ELEMS = 100000;
        ChunkedArrayList l = new ChunkedArrayList();
        Assertions.assertTrue((boolean)l.isEmpty());
        for (int i = 0; i < 100000; ++i) {
            l.add((Object)i);
        }
        Assertions.assertFalse((boolean)l.isEmpty());
        Assertions.assertEquals((int)100000, (int)l.size());
        Assertions.assertTrue((l.getNumChunks() > 10 ? 1 : 0) != 0);
        Assertions.assertEquals((int)8192, (int)l.getMaxChunkSize());
    }

    @Test
    public void testIterator() {
        int i;
        ChunkedArrayList l = new ChunkedArrayList();
        for (i = 0; i < 30000; ++i) {
            l.add((Object)i);
        }
        i = 0;
        Iterator iterator = l.iterator();
        while (iterator.hasNext()) {
            int fromList = (Integer)iterator.next();
            Assertions.assertEquals((int)i, (int)fromList);
            ++i;
        }
    }

    @Test
    public void testPerformance() {
        String obj = "hello world";
        int numElems = 1000000;
        int numTrials = 5;
        for (int trial = 0; trial < 5; ++trial) {
            int i;
            System.gc();
            ArrayList<String> arrayList = new ArrayList<String>();
            StopWatch sw = new StopWatch();
            sw.start();
            for (i = 0; i < 1000000; ++i) {
                arrayList.add(obj);
            }
            System.out.println("       ArrayList " + sw.now(TimeUnit.MILLISECONDS));
            System.gc();
            ChunkedArrayList chunkedList = new ChunkedArrayList();
            sw = new StopWatch();
            sw.start();
            for (i = 0; i < 1000000; ++i) {
                chunkedList.add((Object)obj);
            }
            System.out.println("ChunkedArrayList " + sw.now(TimeUnit.MILLISECONDS));
        }
    }

    @Test
    public void testRemovals() throws Exception {
        Integer val;
        int i;
        int NUM_ELEMS = 100000;
        ChunkedArrayList list = new ChunkedArrayList();
        for (int i2 = 0; i2 < 100000; ++i2) {
            list.add((Object)i2);
        }
        Iterator iter = list.iterator();
        for (i = 0; i < 100000; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            val = (Integer)iter.next();
            Assertions.assertEquals((Integer)i, (Integer)val);
        }
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertEquals((int)100000, (int)list.size());
        iter = list.iterator();
        for (i = 0; i < 100000; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            val = (Integer)iter.next();
            Assertions.assertEquals((Integer)i, (Integer)val);
            if (i % 2 != 0) continue;
            iter.remove();
        }
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertEquals((int)50000, (int)list.size());
        iter = list.iterator();
        for (i = 0; i < 50000; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            val = (Integer)iter.next();
            Assertions.assertEquals((Integer)(1 + 2 * i), (Integer)val);
            iter.remove();
        }
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertEquals((int)0, (int)list.size());
        Assertions.assertTrue((boolean)list.isEmpty());
        iter = list.iterator();
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testGet() throws Exception {
        int NUM_ELEMS = 100001;
        ChunkedArrayList list = new ChunkedArrayList();
        for (int i = 0; i < 100001; ++i) {
            list.add((Object)i);
        }
        Assertions.assertEquals((Integer)100, (Integer)((Integer)list.get(100)));
        Assertions.assertEquals((Integer)1000, (Integer)((Integer)list.get(1000)));
        Assertions.assertEquals((Integer)10000, (Integer)((Integer)list.get(10000)));
        Assertions.assertEquals((Integer)100000, (Integer)((Integer)list.get(100000)));
        Iterator iter = list.iterator();
        iter.next();
        iter.remove();
        Assertions.assertEquals((Integer)1, (Integer)((Integer)list.get(0)));
        iter = list.iterator();
        for (int i = 0; i < 500; ++i) {
            iter.next();
        }
        iter.remove();
        Assertions.assertEquals((Integer)502, (Integer)((Integer)list.get(500)));
        Assertions.assertEquals((Integer)602, (Integer)((Integer)list.get(600)));
    }
}

