/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.util.AutoCloseableLock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAutoCloseableLock {
    @Test
    public void testLockAcquireRelease() {
        AutoCloseableLock lock = new AutoCloseableLock();
        AutoCloseableLock newlock = lock.acquire();
        Assertions.assertEquals((Object)newlock, (Object)lock);
        Assertions.assertTrue((boolean)lock.isLocked());
        lock.release();
        Assertions.assertFalse((boolean)lock.isLocked());
    }

    @Test
    public void testMultipleThread() throws Exception {
        final AutoCloseableLock lock = new AutoCloseableLock();
        lock.acquire();
        Assertions.assertTrue((boolean)lock.isLocked());
        Thread competingThread = new Thread(){

            @Override
            public void run() {
                Assertions.assertTrue((boolean)lock.isLocked());
                Assertions.assertFalse((boolean)lock.tryLock());
            }
        };
        competingThread.start();
        competingThread.join();
        Assertions.assertTrue((boolean)lock.isLocked());
        lock.release();
        Assertions.assertFalse((boolean)lock.isLocked());
    }

    @Test
    public void testTryWithResourceSyntax() throws Exception {
        final AutoCloseableLock lock = new AutoCloseableLock();
        try (AutoCloseableLock localLock = lock.acquire();){
            Assertions.assertEquals((Object)localLock, (Object)lock);
            Assertions.assertTrue((boolean)lock.isLocked());
            Thread competingThread = new Thread(){

                @Override
                public void run() {
                    Assertions.assertTrue((boolean)lock.isLocked());
                    Assertions.assertFalse((boolean)lock.tryLock());
                }
            };
            competingThread.start();
            competingThread.join();
            Assertions.assertTrue((boolean)localLock.isLocked());
        }
        Assertions.assertFalse((boolean)lock.isLocked());
    }
}

