/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.tools.CommandShell;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestCommandShell {
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();

    private String outMsg(String message) {
        return "OUT:\n" + this.outContent.toString() + "\n" + message;
    }

    @BeforeEach
    public void setup() throws Exception {
        System.setOut(new PrintStream(this.outContent));
    }

    @Test
    public void testCommandShellExample() throws Exception {
        Example ex = new Example();
        ex.setConf(new Configuration());
        int rc = 0;
        this.outContent.reset();
        String[] args1 = new String[]{"hello"};
        rc = ex.run(args1);
        Assertions.assertEquals((int)0, (int)rc, (String)this.outMsg("test exit code - normal hello"));
        Assertions.assertTrue((boolean)this.outContent.toString().contains("hello is running"), (String)this.outMsg("test normal hello message"));
        this.outContent.reset();
        String[] args2 = new String[]{"hello", "x"};
        rc = ex.run(args2);
        Assertions.assertEquals((int)1, (int)rc, (String)this.outMsg("test exit code - bad hello"));
        Assertions.assertTrue((boolean)this.outContent.toString().contains("example hello"), (String)this.outMsg("test bad hello message"));
        this.outContent.reset();
        String[] args3 = new String[]{"goodbye"};
        rc = ex.run(args3);
        Assertions.assertEquals((int)0, (int)rc, (String)this.outMsg("test exit code - normal goodbye"));
        Assertions.assertTrue((boolean)this.outContent.toString().contains("goodbye is running"), (String)this.outMsg("test normal goodbye message"));
    }

    public class Example
    extends CommandShell {
        public static final String EXAMPLE = "example";
        public static final String HELLO = "hello";
        public static final String HELLO_MSG = "hello is running";
        public static final String GOODBYE = "goodbye";
        public static final String GOODBYE_MSG = "goodbye is running";
        public String[] savedArgs = null;

        protected int init(String[] args) throws Exception {
            String command = args[0];
            if (command.equals(HELLO)) {
                this.setSubCommand(new Hello());
            } else if (command.equals(GOODBYE)) {
                this.setSubCommand(new Goodbye());
            } else {
                return 1;
            }
            this.savedArgs = args;
            return 0;
        }

        public String getCommandUsage() {
            return EXAMPLE;
        }

        public class Goodbye
        extends CommandShell.SubCommand {
            public static final String GOODBYE_USAGE = "example goodbye";

            public Goodbye() {
                super((CommandShell)Example.this);
            }

            public void execute() throws Exception {
                System.out.println(Example.GOODBYE_MSG);
            }

            public String getUsage() {
                return GOODBYE_USAGE;
            }
        }

        public class Hello
        extends CommandShell.SubCommand {
            public static final String HELLO_USAGE = "example hello";

            public Hello() {
                super((CommandShell)Example.this);
            }

            public boolean validate() {
                return Example.this.savedArgs.length == 1;
            }

            public void execute() throws Exception {
                System.out.println(Example.HELLO_MSG);
            }

            public String getUsage() {
                return HELLO_USAGE;
            }
        }
    }
}

