/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service.launcher.testservices;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.launcher.LaunchableService;
import org.apache.hadoop.service.launcher.testservices.RunningService;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchableRunningService
extends RunningService
implements LaunchableService {
    public static final String NAME = "org.apache.hadoop.service.launcher.testservices.LaunchableRunningService";
    public static final String ARG_FAILING = "--failing";
    public static final String EXIT_CODE_PROP = "exit.code";
    private static final Logger LOG = LoggerFactory.getLogger(LaunchableRunningService.class);
    private int exitCode = 0;

    public LaunchableRunningService() {
        this("LaunchableRunningService");
    }

    public LaunchableRunningService(String name) {
        super(name);
    }

    public Configuration bindArgs(Configuration config, List<String> args) throws Exception {
        Assertions.assertEquals((Object)Service.STATE.NOTINITED, (Object)this.getServiceState());
        for (String arg : args) {
            LOG.info(arg);
        }
        Configuration newConf = new Configuration(config);
        if (args.contains(ARG_FAILING)) {
            LOG.info("CLI contains --failing");
            this.failInRun = true;
            newConf.setInt(EXIT_CODE_PROP, 5);
        }
        return newConf;
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        if (conf.getBoolean("fail.runnable", false)) {
            this.exitCode = -1;
        }
        this.exitCode = conf.getInt(EXIT_CODE_PROP, this.exitCode);
    }

    @Override
    protected void serviceStart() throws Exception {
    }

    public int execute() throws Exception {
        Thread.sleep(this.delayTime);
        if (this.failInRun) {
            return this.exitCode;
        }
        return 0;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }
}

