/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.http;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.http.CrossOriginFilter;
import org.apache.hadoop.test.MockitoUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestCrossOriginFilter {
    @Test
    public void testSameOrigin() throws ServletException, IOException {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("allowed-origins", "");
        FilterConfigTest filterConfig = new FilterConfigTest(conf);
        HttpServletRequest mockReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockReq.getHeader("Origin")).thenReturn(null);
        HttpServletResponse mockRes = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain mockChain = (FilterChain)Mockito.mock(FilterChain.class);
        CrossOriginFilter filter = new CrossOriginFilter();
        filter.init((FilterConfig)filterConfig);
        filter.doFilter((ServletRequest)mockReq, (ServletResponse)mockRes, mockChain);
        MockitoUtil.verifyZeroInteractions(mockRes);
        ((FilterChain)Mockito.verify((Object)mockChain)).doFilter((ServletRequest)mockReq, (ServletResponse)mockRes);
    }

    @Test
    public void testAllowAllOrigins() throws ServletException, IOException {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("allowed-origins", "*");
        FilterConfigTest filterConfig = new FilterConfigTest(conf);
        CrossOriginFilter filter = new CrossOriginFilter();
        filter.init((FilterConfig)filterConfig);
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("example.com"));
    }

    @Test
    public void testEncodeHeaders() {
        String validOrigin = "http://localhost:12345";
        String encodedValidOrigin = CrossOriginFilter.encodeHeader((String)validOrigin);
        Assertions.assertEquals((Object)validOrigin, (Object)encodedValidOrigin, (String)"Valid origin encoding should match exactly");
        String httpResponseSplitOrigin = validOrigin + " \nSecondHeader: value";
        String encodedResponseSplitOrigin = CrossOriginFilter.encodeHeader((String)httpResponseSplitOrigin);
        Assertions.assertEquals((Object)validOrigin, (Object)encodedResponseSplitOrigin, (String)"Http response split origin should be protected against");
        String validOriginList = "http://foo.example.com:12345 http://bar.example.com:12345";
        String encodedValidOriginList = CrossOriginFilter.encodeHeader((String)validOriginList);
        Assertions.assertEquals((Object)validOriginList, (Object)encodedValidOriginList, (String)"Valid origin list encoding should match exactly");
    }

    @Test
    public void testPatternMatchingOrigins() throws ServletException, IOException {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("allowed-origins", "*.example.com");
        FilterConfigTest filterConfig = new FilterConfigTest(conf);
        CrossOriginFilter filter = new CrossOriginFilter();
        filter.init((FilterConfig)filterConfig);
        Assertions.assertFalse((boolean)filter.areOriginsAllowed("example.com"));
        Assertions.assertFalse((boolean)filter.areOriginsAllowed("foo:example.com"));
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("foo.example.com"));
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("foo.bar.example.com"));
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("foo.example.com foo.nomatch.com"));
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("foo.nomatch.com foo.example.com"));
        Assertions.assertFalse((boolean)filter.areOriginsAllowed("foo.nomatch1.com foo.nomatch2.com"));
    }

    @Test
    public void testRegexPatternMatchingOrigins() throws ServletException, IOException {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("allowed-origins", "regex:.*[.]example[.]com");
        FilterConfigTest filterConfig = new FilterConfigTest(conf);
        CrossOriginFilter filter = new CrossOriginFilter();
        filter.init((FilterConfig)filterConfig);
        Assertions.assertFalse((boolean)filter.areOriginsAllowed("example.com"));
        Assertions.assertFalse((boolean)filter.areOriginsAllowed("foo:example.com"));
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("foo.example.com"));
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("foo.bar.example.com"));
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("foo.example.com foo.nomatch.com"));
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("foo.nomatch.com foo.example.com"));
        Assertions.assertFalse((boolean)filter.areOriginsAllowed("foo.nomatch1.com foo.nomatch2.com"));
    }

    @Test
    public void testComplexRegexPatternMatchingOrigins() throws ServletException, IOException {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("allowed-origins", "regex:https?:\\/\\/sub1[.]example[.]com(:[0-9]+)?");
        FilterConfigTest filterConfig = new FilterConfigTest(conf);
        CrossOriginFilter filter = new CrossOriginFilter();
        filter.init((FilterConfig)filterConfig);
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("http://sub1.example.com"));
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("https://sub1.example.com"));
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("http://sub1.example.com:1234"));
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("https://sub1.example.com:8080"));
        Assertions.assertFalse((boolean)filter.areOriginsAllowed("foo.nomatch1.com foo.nomatch2.com"));
    }

    @Test
    public void testMixedRegexPatternMatchingOrigins() throws ServletException, IOException {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("allowed-origins", "regex:https?:\\/\\/sub1[.]example[.]com(:[0-9]+)?, *.example2.com");
        FilterConfigTest filterConfig = new FilterConfigTest(conf);
        CrossOriginFilter filter = new CrossOriginFilter();
        filter.init((FilterConfig)filterConfig);
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("http://sub1.example.com"));
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("https://sub1.example.com"));
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("http://sub1.example.com:1234"));
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("https://sub1.example.com:8080"));
        Assertions.assertFalse((boolean)filter.areOriginsAllowed("example2.com"));
        Assertions.assertFalse((boolean)filter.areOriginsAllowed("foo:example2.com"));
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("foo.example2.com"));
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("foo.bar.example2.com"));
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("foo.example2.com foo.nomatch.com"));
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("foo.nomatch.com foo.example2.com"));
        Assertions.assertFalse((boolean)filter.areOriginsAllowed("foo.nomatch1.com foo.nomatch2.com"));
    }

    @Test
    public void testDisallowedOrigin() throws ServletException, IOException {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("allowed-origins", "example.com");
        FilterConfigTest filterConfig = new FilterConfigTest(conf);
        HttpServletRequest mockReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockReq.getHeader("Origin")).thenReturn((Object)"example.org");
        HttpServletResponse mockRes = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain mockChain = (FilterChain)Mockito.mock(FilterChain.class);
        CrossOriginFilter filter = new CrossOriginFilter();
        filter.init((FilterConfig)filterConfig);
        filter.doFilter((ServletRequest)mockReq, (ServletResponse)mockRes, mockChain);
        MockitoUtil.verifyZeroInteractions(mockRes);
        ((FilterChain)Mockito.verify((Object)mockChain)).doFilter((ServletRequest)mockReq, (ServletResponse)mockRes);
    }

    @Test
    public void testDisallowedMethod() throws ServletException, IOException {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("allowed-origins", "example.com");
        FilterConfigTest filterConfig = new FilterConfigTest(conf);
        HttpServletRequest mockReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockReq.getHeader("Origin")).thenReturn((Object)"example.com");
        Mockito.when((Object)mockReq.getHeader("Access-Control-Request-Method")).thenReturn((Object)"DISALLOWED_METHOD");
        HttpServletResponse mockRes = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain mockChain = (FilterChain)Mockito.mock(FilterChain.class);
        CrossOriginFilter filter = new CrossOriginFilter();
        filter.init((FilterConfig)filterConfig);
        filter.doFilter((ServletRequest)mockReq, (ServletResponse)mockRes, mockChain);
        MockitoUtil.verifyZeroInteractions(mockRes);
        ((FilterChain)Mockito.verify((Object)mockChain)).doFilter((ServletRequest)mockReq, (ServletResponse)mockRes);
    }

    @Test
    public void testDisallowedHeader() throws ServletException, IOException {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("allowed-origins", "example.com");
        FilterConfigTest filterConfig = new FilterConfigTest(conf);
        HttpServletRequest mockReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockReq.getHeader("Origin")).thenReturn((Object)"example.com");
        Mockito.when((Object)mockReq.getHeader("Access-Control-Request-Method")).thenReturn((Object)"GET");
        Mockito.when((Object)mockReq.getHeader("Access-Control-Request-Headers")).thenReturn((Object)"Disallowed-Header");
        HttpServletResponse mockRes = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain mockChain = (FilterChain)Mockito.mock(FilterChain.class);
        CrossOriginFilter filter = new CrossOriginFilter();
        filter.init((FilterConfig)filterConfig);
        filter.doFilter((ServletRequest)mockReq, (ServletResponse)mockRes, mockChain);
        MockitoUtil.verifyZeroInteractions(mockRes);
        ((FilterChain)Mockito.verify((Object)mockChain)).doFilter((ServletRequest)mockReq, (ServletResponse)mockRes);
    }

    @Test
    public void testCrossOriginFilter() throws ServletException, IOException {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("allowed-origins", "example.com");
        FilterConfigTest filterConfig = new FilterConfigTest(conf);
        HttpServletRequest mockReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockReq.getHeader("Origin")).thenReturn((Object)"example.com");
        Mockito.when((Object)mockReq.getHeader("Access-Control-Request-Method")).thenReturn((Object)"GET");
        Mockito.when((Object)mockReq.getHeader("Access-Control-Request-Headers")).thenReturn((Object)"X-Requested-With");
        HttpServletResponse mockRes = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain mockChain = (FilterChain)Mockito.mock(FilterChain.class);
        CrossOriginFilter filter = new CrossOriginFilter();
        filter.init((FilterConfig)filterConfig);
        filter.doFilter((ServletRequest)mockReq, (ServletResponse)mockRes, mockChain);
        ((HttpServletResponse)Mockito.verify((Object)mockRes)).setHeader("Access-Control-Allow-Origin", "example.com");
        ((HttpServletResponse)Mockito.verify((Object)mockRes)).setHeader("Access-Control-Allow-Credentials", Boolean.TRUE.toString());
        ((HttpServletResponse)Mockito.verify((Object)mockRes)).setHeader("Access-Control-Allow-Methods", filter.getAllowedMethodsHeader());
        ((HttpServletResponse)Mockito.verify((Object)mockRes)).setHeader("Access-Control-Allow-Headers", filter.getAllowedHeadersHeader());
        ((FilterChain)Mockito.verify((Object)mockChain)).doFilter((ServletRequest)mockReq, (ServletResponse)mockRes);
    }

    @Test
    public void testCrossOriginFilterAfterRestart() throws ServletException {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("allowed-origins", "example.com");
        conf.put("allowed-headers", "X-Requested-With,Accept");
        conf.put("allowed-methods", "GET,POST");
        FilterConfigTest filterConfig = new FilterConfigTest(conf);
        CrossOriginFilter filter = new CrossOriginFilter();
        filter.init((FilterConfig)filterConfig);
        Assertions.assertTrue((filter.getAllowedHeadersHeader().compareTo("X-Requested-With,Accept") == 0 ? 1 : 0) != 0, (String)"Allowed headers do not match");
        Assertions.assertTrue((filter.getAllowedMethodsHeader().compareTo("GET,POST") == 0 ? 1 : 0) != 0, (String)"Allowed methods do not match");
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("example.com"));
        filter.destroy();
        conf.clear();
        conf.put("allowed-origins", "newexample.com");
        conf.put("allowed-headers", "Content-Type,Origin");
        conf.put("allowed-methods", "GET,HEAD");
        filterConfig = new FilterConfigTest(conf);
        filter.init((FilterConfig)filterConfig);
        Assertions.assertTrue((filter.getAllowedHeadersHeader().compareTo("Content-Type,Origin") == 0 ? 1 : 0) != 0, (String)"Allowed headers do not match");
        Assertions.assertTrue((filter.getAllowedMethodsHeader().compareTo("GET,HEAD") == 0 ? 1 : 0) != 0, (String)"Allowed methods do not match");
        Assertions.assertTrue((boolean)filter.areOriginsAllowed("newexample.com"));
        filter.destroy();
    }

    private static class FilterConfigTest
    implements FilterConfig {
        final Map<String, String> map;

        FilterConfigTest(Map<String, String> map) {
            this.map = map;
        }

        public String getFilterName() {
            return "test-filter";
        }

        public String getInitParameter(String key) {
            return this.map.get(key);
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(this.map.keySet());
        }

        public ServletContext getServletContext() {
            return null;
        }
    }
}

