/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.KDiag;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=30L)
public class TestKDiagNoKDC
extends Assertions {
    private static final Logger LOG = LoggerFactory.getLogger(TestKDiagNoKDC.class);
    public static final String KEYLEN = "128";
    private static Configuration conf = new Configuration();

    @BeforeAll
    public static void nameThread() {
        Thread.currentThread().setName("JUnit");
    }

    @BeforeEach
    public void reset() {
        UserGroupInformation.reset();
    }

    void kdiagFailure(String category, String ... args) throws Exception {
        block2: {
            try {
                int ex = KDiag.exec((Configuration)conf, (String[])args);
                LOG.error("Expected an exception in category {}, return code {}", (Object)category, (Object)ex);
            }
            catch (KDiag.KerberosDiagsFailure e) {
                if (e.getCategory().equals(category)) break block2;
                LOG.error("Expected an exception in category {}, got {}", new Object[]{category, e, e});
                throw e;
            }
        }
    }

    int kdiag(String ... args) throws Exception {
        return KDiag.exec((Configuration)conf, (String[])args);
    }

    @Test
    public void testKDiagStandalone() throws Throwable {
        this.kdiagFailure("LOGIN", "--keylen", KEYLEN);
    }

    @Test
    public void testKDiagNoLogin() throws Throwable {
        this.kdiagFailure("LOGIN", "--keylen", KEYLEN, "--nologin");
    }

    @Test
    public void testKDiagStandaloneNofail() throws Throwable {
        this.kdiag("--keylen", KEYLEN, "--nofail");
    }

    @Test
    public void testKDiagUsage() throws Throwable {
        TestKDiagNoKDC.assertEquals((int)-1, (int)this.kdiag("usage"));
    }

    @Test
    public void testTokenFile() throws Throwable {
        conf.set("hadoop.token.files", "SomeNonExistentFile");
        this.kdiagFailure("TOKEN", "--keylen", KEYLEN);
        conf.unset("hadoop.token.files");
    }
}

