/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestAuthenticationFilter {
    @Test
    public void testConfiguration() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.http.authentication.foo", "bar");
        conf.set("bind.address", "barhost");
        FilterContainer container = (FilterContainer)Mockito.mock(FilterContainer.class);
        ((FilterContainer)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Object[] args = invocationOnMock.getArguments();
                Assertions.assertEquals((Object)"authentication", (Object)args[0]);
                Assertions.assertEquals((Object)AuthenticationFilter.class.getName(), (Object)args[1]);
                Map conf = (Map)args[2];
                Assertions.assertEquals((Object)"/", conf.get("cookie.path"));
                Assertions.assertEquals((Object)"simple", conf.get("type"));
                Assertions.assertEquals((Object)"36000", conf.get("token.validity"));
                Assertions.assertNull(conf.get("cookie.domain"));
                Assertions.assertEquals((Object)"true", conf.get("simple.anonymous.allowed"));
                Assertions.assertEquals((Object)"HTTP/barhost@LOCALHOST", conf.get("kerberos.principal"));
                Assertions.assertEquals((Object)(System.getProperty("user.home") + "/hadoop.keytab"), conf.get("kerberos.keytab"));
                Assertions.assertEquals((Object)"bar", conf.get("foo"));
                return null;
            }
        }).when((Object)container)).addFilter((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        new AuthenticationFilterInitializer().initFilter(container, conf);
    }
}

