/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.portmap;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcReply;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Credentials;
import org.apache.hadoop.oncrpc.security.CredentialsNone;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.apache.hadoop.portmap.Portmap;
import org.apache.hadoop.portmap.PortmapMapping;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestPortmap {
    private static Portmap pm = new Portmap();
    private static final int SHORT_TIMEOUT_MILLISECONDS = 10;
    private static final int RETRY_TIMES = 5;
    private int xid;

    @BeforeAll
    public static void setup() throws InterruptedException {
        pm.start(10, (SocketAddress)new InetSocketAddress("localhost", 0), (SocketAddress)new InetSocketAddress("localhost", 0));
    }

    @AfterAll
    public static void tearDown() {
        pm.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10L)
    public void testIdle() throws InterruptedException, IOException {
        try (Socket s = new Socket();){
            int i;
            s.connect(pm.getTcpServerLocalAddress());
            for (i = 0; !s.isConnected() && i < 5; ++i) {
                Thread.sleep(10L);
            }
            Assertions.assertTrue((s.isConnected() && i < 5 ? 1 : 0) != 0, (String)"Failed to connect to the server");
            int b = s.getInputStream().read();
            Assertions.assertTrue((b == -1 ? 1 : 0) != 0, (String)"The server failed to disconnect");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10L)
    public void testRegistration() throws IOException, InterruptedException, IllegalAccessException {
        XDR req = new XDR();
        RpcCall.getInstance((int)(++this.xid), (int)100000, (int)2, (int)1, (Credentials)new CredentialsNone(), (Verifier)new VerifierNone()).write(req);
        PortmapMapping sent = new PortmapMapping(90000, 1, 6, 1234);
        sent.serialize(req);
        byte[] reqBuf = req.getBytes();
        DatagramPacket p = new DatagramPacket(reqBuf, reqBuf.length, pm.getUdpServerLoAddress());
        try (DatagramSocket s = new DatagramSocket();){
            s.send(p);
            byte[] receiveData = new byte[65535];
            DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
            s.setSoTimeout(2000);
            s.receive(receivePacket);
            XDR xdr = new XDR(Arrays.copyOfRange(receiveData, 0, receivePacket.getLength()));
            RpcReply reply = RpcReply.read((XDR)xdr);
            Assertions.assertEquals((Object)reply.getState(), (Object)RpcReply.ReplyState.MSG_ACCEPTED);
        }
        Thread.sleep(100L);
        boolean found = false;
        Map map = pm.getHandler().getMap();
        for (PortmapMapping m : map.values()) {
            if (m.getPort() != sent.getPort() || !PortmapMapping.key((PortmapMapping)m).equals(PortmapMapping.key((PortmapMapping)sent))) continue;
            found = true;
            break;
        }
        Assertions.assertTrue((boolean)found, (String)"Registration failed");
    }
}

