/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.hadoop.oncrpc.XDR;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestXDR {
    static final int WRITE_VALUE = 23;

    private void serializeInt(int times) {
        XDR w = new XDR();
        for (int i = 0; i < times; ++i) {
            w.writeInt(23);
        }
        XDR r = w.asReadOnlyWrap();
        for (int i = 0; i < times; ++i) {
            Assertions.assertEquals((int)23, (int)r.readInt());
        }
    }

    private void serializeLong(int times) {
        XDR w = new XDR();
        for (int i = 0; i < times; ++i) {
            w.writeLongAsHyper(23L);
        }
        XDR r = w.asReadOnlyWrap();
        for (int i = 0; i < times; ++i) {
            Assertions.assertEquals((long)23L, (long)r.readHyper());
        }
    }

    @Test
    public void testPerformance() {
        int TEST_TIMES = 0x800000;
        this.serializeInt(0x800000);
        this.serializeLong(0x800000);
    }
}

