/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.hadoop.oncrpc.RpcMessage;
import org.apache.hadoop.oncrpc.XDR;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRpcMessage {
    private RpcMessage getRpcMessage(int xid, RpcMessage.Type msgType) {
        return new RpcMessage(xid, msgType){

            public XDR write(XDR xdr) {
                return null;
            }
        };
    }

    @Test
    public void testRpcMessage() {
        RpcMessage msg = this.getRpcMessage(0, RpcMessage.Type.RPC_CALL);
        Assertions.assertEquals((int)0, (int)msg.getXid());
        Assertions.assertEquals((Object)RpcMessage.Type.RPC_CALL, (Object)msg.getMessageType());
    }

    @Test
    public void testValidateMessage() {
        RpcMessage msg = this.getRpcMessage(0, RpcMessage.Type.RPC_CALL);
        msg.validateMessageType(RpcMessage.Type.RPC_CALL);
    }

    @Test
    public void testValidateMessageException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            RpcMessage msg = this.getRpcMessage(0, RpcMessage.Type.RPC_CALL);
            msg.validateMessageType(RpcMessage.Type.RPC_REPLY);
        });
    }
}

