/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.AbstractDNSToSwitchMapping;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSwitchMapping
extends Assertions {
    @Test
    public void testStandaloneClassesAssumedMultiswitch() throws Throwable {
        StandaloneSwitchMapping mapping = new StandaloneSwitchMapping();
        TestSwitchMapping.assertFalse((boolean)AbstractDNSToSwitchMapping.isMappingSingleSwitch((DNSToSwitchMapping)mapping), (String)("Expected to be multi switch " + mapping));
    }

    @Test
    public void testCachingRelays() throws Throwable {
        CachedDNSToSwitchMapping mapping = new CachedDNSToSwitchMapping((DNSToSwitchMapping)new StandaloneSwitchMapping());
        TestSwitchMapping.assertFalse((boolean)mapping.isSingleSwitch(), (String)("Expected to be multi switch " + mapping));
    }

    @Test
    public void testCachingRelaysStringOperations() throws Throwable {
        Configuration conf = new Configuration();
        String scriptname = "mappingscript.sh";
        conf.set("net.topology.script.file.name", scriptname);
        ScriptBasedMapping scriptMapping = new ScriptBasedMapping(conf);
        TestSwitchMapping.assertTrue((boolean)scriptMapping.toString().contains(scriptname), (String)("Did not find " + scriptname + " in " + scriptMapping));
        CachedDNSToSwitchMapping mapping = new CachedDNSToSwitchMapping((DNSToSwitchMapping)scriptMapping);
        TestSwitchMapping.assertTrue((boolean)mapping.toString().contains(scriptname), (String)("Did not find " + scriptname + " in " + mapping));
    }

    @Test
    public void testCachingRelaysStringOperationsToNullScript() throws Throwable {
        Configuration conf = new Configuration();
        ScriptBasedMapping scriptMapping = new ScriptBasedMapping(conf);
        TestSwitchMapping.assertTrue((boolean)scriptMapping.toString().contains("no script"), (String)("Did not find no script in " + scriptMapping));
        CachedDNSToSwitchMapping mapping = new CachedDNSToSwitchMapping((DNSToSwitchMapping)scriptMapping);
        TestSwitchMapping.assertTrue((boolean)mapping.toString().contains("no script"), (String)("Did not find no script in " + mapping));
    }

    @Test
    public void testNullMapping() {
        TestSwitchMapping.assertFalse((boolean)AbstractDNSToSwitchMapping.isMappingSingleSwitch(null));
    }

    private static class StandaloneSwitchMapping
    implements DNSToSwitchMapping {
        private StandaloneSwitchMapping() {
        }

        public List<String> resolve(List<String> names) {
            return names;
        }

        public void reloadCachedMappings() {
        }

        public void reloadCachedMappings(List<String> names) {
        }
    }
}

